/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VpnKeyOff: ImageVector
    get() {
        if (_vpnKeyOff != null) {
            return _vpnKeyOff!!
        }
        _vpnKeyOff = materialIcon(name = "Sharp.VpnKeyOff") {
            materialPath {
                moveTo(20.83f, 18.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(12.83f)
                lineTo(20.83f, 18.0f)
                close()
                moveTo(19.78f, 22.61f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(2.59f, 2.59f)
                curveTo(2.2f, 7.85f, 1.0f, 9.79f, 1.0f, 12.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                curveToRelative(2.21f, 0.0f, 4.15f, -1.2f, 5.18f, -2.99f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(8.99f, 11.82f)
                curveTo(9.0f, 11.88f, 9.0f, 11.94f, 9.0f, 12.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                curveToRelative(0.06f, 0.0f, 0.12f, 0.0f, 0.18f, 0.01f)
                lineTo(8.99f, 11.82f)
                close()
            }
        }
        return _vpnKeyOff!!
    }

private var _vpnKeyOff: ImageVector? = null
