/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.WifiCalling: ImageVector
    get() {
        if (_wifiCalling != null) {
            return _wifiCalling!!
        }
        _wifiCalling = materialIcon(name = "Sharp.WifiCalling") {
            materialPath {
                moveTo(13.21f, 17.37f)
                curveToRelative(-2.83f, -1.44f, -5.15f, -3.75f, -6.59f, -6.59f)
                lineToRelative(2.53f, -2.53f)
                lineTo(8.54f, 3.0f)
                horizontalLineTo(3.03f)
                curveTo(2.45f, 13.18f, 10.82f, 21.55f, 21.0f, 20.97f)
                verticalLineToRelative(-5.51f)
                lineToRelative(-5.27f, -0.61f)
                lineTo(13.21f, 17.37f)
                close()
            }
            materialPath {
                moveTo(22.0f, 4.95f)
                curveTo(21.79f, 4.78f, 19.67f, 3.0f, 16.5f, 3.0f)
                curveToRelative(-3.18f, 0.0f, -5.29f, 1.78f, -5.5f, 1.95f)
                lineTo(16.5f, 12.0f)
                lineTo(22.0f, 4.95f)
                close()
            }
        }
        return _wifiCalling!!
    }

private var _wifiCalling: ImageVector? = null
