/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FireTruck: ImageVector
    get() {
        if (_fireTruck != null) {
            return _fireTruck!!
        }
        _fireTruck = materialIcon(name = "TwoTone.FireTruck") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(3.0f, 16.0f)
                horizontalLineToRelative(1.78f)
                curveToRelative(0.55f, -0.61f, 1.34f, -1.0f, 2.22f, -1.0f)
                reflectiveCurveToRelative(1.67f, 0.39f, 2.22f, 1.0f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.0f, 16.0f)
                horizontalLineToRelative(0.78f)
                curveToRelative(0.55f, -0.61f, 1.34f, -1.0f, 2.22f, -1.0f)
                reflectiveCurveToRelative(1.67f, 0.39f, 2.22f, 1.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(-7.0f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath {
                moveTo(22.9f, 10.69f)
                lineToRelative(-1.44f, -4.32f)
                curveTo(21.18f, 5.55f, 20.42f, 5.0f, 19.56f, 5.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-6.68f)
                curveTo(23.0f, 11.11f, 22.97f, 10.9f, 22.9f, 10.69f)
                close()
                moveTo(7.0f, 19.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(7.55f, 19.0f, 7.0f, 19.0f)
                close()
                moveTo(12.0f, 16.0f)
                horizontalLineTo(9.22f)
                curveTo(8.67f, 15.39f, 7.89f, 15.0f, 7.0f, 15.0f)
                reflectiveCurveToRelative(-1.67f, 0.39f, -2.22f, 1.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(9.0f)
                verticalLineTo(16.0f)
                close()
                moveTo(14.0f, 7.0f)
                horizontalLineToRelative(5.56f)
                lineToRelative(1.33f, 4.0f)
                horizontalLineTo(14.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(17.0f, 19.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(17.55f, 19.0f, 17.0f, 19.0f)
                close()
                moveTo(21.0f, 16.0f)
                horizontalLineToRelative(-1.78f)
                curveToRelative(-0.55f, -0.61f, -1.34f, -1.0f, -2.22f, -1.0f)
                reflectiveCurveToRelative(-1.67f, 0.39f, -2.22f, 1.0f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(7.0f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 8.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(8.5f)
                close()
                moveTo(5.25f, 8.5f)
                horizontalLineTo(3.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.75f)
                verticalLineTo(8.5f)
                close()
                moveTo(8.5f, 8.5f)
                horizontalLineTo(6.75f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(8.5f)
                verticalLineTo(8.5f)
                close()
            }
        }
        return _fireTruck!!
    }

private var _fireTruck: ImageVector? = null
