/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PartyMode: ImageVector
    get() {
        if (_partyMode != null) {
            return _partyMode!!
        }
        _partyMode = materialIcon(name = "TwoTone.PartyMode") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.95f, 6.0f)
                lineToRelative(-0.59f, -0.65f)
                lineTo(14.12f, 4.0f)
                lineTo(9.88f, 4.0f)
                lineTo(8.65f, 5.35f)
                lineToRelative(-0.6f, 0.65f)
                lineTo(4.0f, 6.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(16.0f)
                lineTo(20.0f, 6.0f)
                horizontalLineToRelative(-4.05f)
                close()
                moveTo(7.0f, 12.0f)
                curveToRelative(0.0f, -2.76f, 2.24f, -5.0f, 5.0f, -5.0f)
                curveToRelative(1.63f, 0.0f, 3.06f, 0.79f, 3.98f, 2.0f)
                lineTo(12.0f, 9.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                curveToRelative(0.0f, 0.35f, 0.07f, 0.69f, 0.18f, 1.0f)
                lineTo(7.1f, 13.0f)
                curveToRelative(-0.06f, -0.32f, -0.1f, -0.66f, -0.1f, -1.0f)
                close()
                moveTo(17.0f, 12.0f)
                curveToRelative(0.0f, 2.76f, -2.24f, 5.0f, -5.0f, 5.0f)
                curveToRelative(-1.63f, 0.0f, -3.06f, -0.79f, -3.98f, -2.0f)
                lineTo(12.0f, 15.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                curveToRelative(0.0f, -0.35f, -0.07f, -0.69f, -0.18f, -1.0f)
                horizontalLineToRelative(2.08f)
                curveToRelative(0.07f, 0.32f, 0.1f, 0.66f, 0.1f, 1.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineToRelative(-3.17f)
                lineTo(15.0f, 2.0f)
                lineTo(9.0f, 2.0f)
                lineTo(7.17f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(22.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(20.0f, 18.0f)
                lineTo(4.0f, 18.0f)
                lineTo(4.0f, 6.0f)
                horizontalLineToRelative(4.05f)
                lineToRelative(0.59f, -0.65f)
                lineTo(9.88f, 4.0f)
                horizontalLineToRelative(4.24f)
                lineToRelative(1.24f, 1.35f)
                lineToRelative(0.59f, 0.65f)
                lineTo(20.0f, 6.0f)
                verticalLineToRelative(12.0f)
                close()
                moveTo(9.0f, 12.0f)
                curveToRelative(0.0f, -1.66f, 1.34f, -3.0f, 3.0f, -3.0f)
                horizontalLineToRelative(3.98f)
                curveToRelative(-0.92f, -1.21f, -2.35f, -2.0f, -3.98f, -2.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                curveToRelative(0.0f, 0.34f, 0.04f, 0.68f, 0.1f, 1.0f)
                horizontalLineToRelative(2.08f)
                curveToRelative(-0.11f, -0.31f, -0.18f, -0.65f, -0.18f, -1.0f)
                close()
                moveTo(15.0f, 12.0f)
                curveToRelative(0.0f, 1.66f, -1.34f, 3.0f, -3.0f, 3.0f)
                lineTo(8.02f, 15.0f)
                curveToRelative(0.92f, 1.21f, 2.35f, 2.0f, 3.98f, 2.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                curveToRelative(0.0f, -0.34f, -0.03f, -0.68f, -0.1f, -1.0f)
                horizontalLineToRelative(-2.08f)
                curveToRelative(0.11f, 0.31f, 0.18f, 0.65f, 0.18f, 1.0f)
                close()
            }
        }
        return _partyMode!!
    }

private var _partyMode: ImageVector? = null
