/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PermContactCalendar: ImageVector
    get() {
        if (_permContactCalendar != null) {
            return _permContactCalendar!!
        }
        _permContactCalendar = materialIcon(name = "TwoTone.PermContactCalendar") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.0f, 5.0f)
                lineTo(5.0f, 5.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(14.0f)
                lineTo(19.0f, 5.0f)
                horizontalLineToRelative(-3.0f)
                close()
                moveTo(12.0f, 6.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, 1.35f, 3.0f, 3.0f)
                reflectiveCurveToRelative(-1.35f, 3.0f, -3.0f, 3.0f)
                reflectiveCurveToRelative(-3.0f, -1.35f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.35f, -3.0f, 3.0f, -3.0f)
                close()
                moveTo(18.0f, 18.0f)
                lineTo(6.0f, 18.0f)
                verticalLineToRelative(-1.53f)
                curveToRelative(0.0f, -2.5f, 3.97f, -3.58f, 6.0f, -3.58f)
                reflectiveCurveToRelative(6.0f, 1.08f, 6.0f, 3.58f)
                lineTo(18.0f, 18.0f)
                close()
            }
            materialPath {
                moveTo(20.84f, 4.22f)
                curveToRelative(-0.05f, -0.12f, -0.11f, -0.23f, -0.18f, -0.34f)
                curveToRelative(-0.14f, -0.21f, -0.33f, -0.4f, -0.54f, -0.54f)
                curveToRelative(-0.11f, -0.07f, -0.22f, -0.13f, -0.34f, -0.18f)
                curveToRelative(-0.24f, -0.1f, -0.5f, -0.16f, -0.78f, -0.16f)
                horizontalLineToRelative(-1.0f)
                lineTo(18.0f, 1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                lineTo(8.0f, 3.0f)
                lineTo(8.0f, 1.0f)
                lineTo(6.0f, 1.0f)
                verticalLineToRelative(2.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-0.42f, 0.0f, -0.8f, 0.13f, -1.12f, 0.34f)
                curveToRelative(-0.21f, 0.14f, -0.4f, 0.33f, -0.54f, 0.54f)
                curveToRelative(-0.07f, 0.11f, -0.13f, 0.22f, -0.18f, 0.34f)
                curveToRelative(-0.1f, 0.24f, -0.16f, 0.5f, -0.16f, 0.78f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.28f, 0.0f, 0.54f, -0.06f, 0.78f, -0.16f)
                curveToRelative(0.12f, -0.05f, 0.23f, -0.11f, 0.34f, -0.18f)
                curveToRelative(0.21f, -0.14f, 0.4f, -0.33f, 0.54f, -0.54f)
                curveToRelative(0.21f, -0.32f, 0.34f, -0.71f, 0.34f, -1.12f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -0.28f, -0.06f, -0.54f, -0.16f, -0.78f)
                close()
                moveTo(19.0f, 19.0f)
                lineTo(5.0f, 19.0f)
                lineTo(5.0f, 5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(12.0f, 12.88f)
                curveToRelative(-2.03f, 0.0f, -6.0f, 1.08f, -6.0f, 3.58f)
                lineTo(6.0f, 18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-1.53f)
                curveToRelative(0.0f, -2.51f, -3.97f, -3.59f, -6.0f, -3.59f)
                close()
                moveTo(8.31f, 16.0f)
                curveToRelative(0.69f, -0.56f, 2.38f, -1.12f, 3.69f, -1.12f)
                reflectiveCurveToRelative(3.01f, 0.56f, 3.69f, 1.12f)
                lineTo(8.31f, 16.0f)
                close()
                moveTo(12.0f, 12.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, -1.35f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.35f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.35f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.35f, 3.0f, 3.0f, 3.0f)
                close()
                moveTo(12.0f, 8.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                close()
            }
        }
        return _permContactCalendar!!
    }

private var _permContactCalendar: ImageVector? = null
