/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.TakeoutDining: ImageVector
    get() {
        if (_takeoutDining != null) {
            return _takeoutDining!!
        }
        _takeoutDining = materialIcon(name = "TwoTone.TakeoutDining") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.83f, 5.0f)
                lineToRelative(-2.8f, 2.73f)
                lineToRelative(0.09f, 1.27f)
                lineToRelative(9.75f, 0.0f)
                lineToRelative(0.09f, -1.27f)
                lineToRelative(-2.8f, -2.73f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(7.79f, 18.0f)
                lineToRelative(8.44f, 0.0f)
                lineToRelative(0.51f, -7.0f)
                lineToRelative(-9.46f, 0.0f)
                close()
            }
            materialPath {
                moveTo(20.59f, 6.05f)
                lineTo(19.0f, 7.63f)
                lineToRelative(0.03f, -0.56f)
                lineTo(14.98f, 3.0f)
                horizontalLineTo(9.02f)
                lineTo(4.97f, 7.07f)
                lineTo(5.0f, 7.57f)
                lineTo(3.41f, 6.01f)
                lineTo(2.0f, 7.44f)
                lineToRelative(3.23f, 3.11f)
                lineTo(5.93f, 20.0f)
                horizontalLineToRelative(12.14f)
                lineToRelative(0.7f, -9.44f)
                lineTo(22.0f, 7.46f)
                lineTo(20.59f, 6.05f)
                close()
                moveTo(16.23f, 18.0f)
                horizontalLineTo(7.79f)
                lineToRelative(-0.51f, -7.0f)
                horizontalLineToRelative(9.46f)
                lineTo(16.23f, 18.0f)
                close()
                moveTo(16.87f, 9.0f)
                horizontalLineTo(7.12f)
                lineTo(7.03f, 7.73f)
                lineTo(9.83f, 5.0f)
                horizontalLineToRelative(4.33f)
                lineToRelative(2.8f, 2.73f)
                lineTo(16.87f, 9.0f)
                close()
            }
        }
        return _takeoutDining!!
    }

private var _takeoutDining: ImageVector? = null
