/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Outlined.HelpCenter: ImageVector
    get() {
        if (_helpCenter != null) {
            return _helpCenter!!
        }
        _helpCenter = materialIcon(name = "AutoMirrored.Outlined.HelpCenter", autoMirror = true) {
            materialPath {
                moveTo(13.25f, 16.74f)
                curveToRelative(0.0f, 0.69f, -0.53f, 1.26f, -1.25f, 1.26f)
                curveToRelative(-0.7f, 0.0f, -1.26f, -0.56f, -1.26f, -1.26f)
                curveToRelative(0.0f, -0.71f, 0.56f, -1.25f, 1.26f, -1.25f)
                curveTo(12.71f, 15.49f, 13.25f, 16.04f, 13.25f, 16.74f)
                close()
                moveTo(11.99f, 6.0f)
                curveToRelative(-1.77f, 0.0f, -2.98f, 1.15f, -3.43f, 2.49f)
                lineToRelative(1.64f, 0.69f)
                curveToRelative(0.22f, -0.67f, 0.74f, -1.48f, 1.8f, -1.48f)
                curveToRelative(1.62f, 0.0f, 1.94f, 1.52f, 1.37f, 2.33f)
                curveToRelative(-0.54f, 0.77f, -1.47f, 1.29f, -1.96f, 2.16f)
                curveToRelative(-0.39f, 0.69f, -0.31f, 1.49f, -0.31f, 1.98f)
                horizontalLineToRelative(1.82f)
                curveToRelative(0.0f, -0.93f, 0.07f, -1.12f, 0.22f, -1.41f)
                curveToRelative(0.39f, -0.72f, 1.11f, -1.06f, 1.87f, -2.17f)
                curveToRelative(0.68f, -1.0f, 0.42f, -2.36f, -0.02f, -3.08f)
                curveTo(14.48f, 6.67f, 13.47f, 6.0f, 11.99f, 6.0f)
                close()
                moveTo(19.0f, 5.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(5.0f)
                moveTo(19.0f, 3.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineTo(19.0f)
                lineTo(19.0f, 3.0f)
                close()
            }
        }
        return _helpCenter!!
    }

private var _helpCenter: ImageVector? = null
