/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.FiberNew: ImageVector
    get() {
        if (_fiberNew != null) {
            return _fiberNew!!
        }
        _fiberNew = materialIcon(name = "Filled.FiberNew") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineTo(4.0f)
                curveTo(2.89f, 4.0f, 2.01f, 4.89f, 2.01f, 6.0f)
                lineTo(2.0f, 18.0f)
                curveToRelative(0.0f, 1.11f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(22.0f, 4.89f, 21.11f, 4.0f, 20.0f, 4.0f)
                close()
                moveTo(8.5f, 15.0f)
                horizontalLineTo(7.3f)
                lineToRelative(-2.55f, -3.5f)
                verticalLineTo(15.0f)
                horizontalLineTo(3.5f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.25f)
                lineToRelative(2.5f, 3.5f)
                verticalLineTo(9.0f)
                horizontalLineTo(8.5f)
                verticalLineTo(15.0f)
                close()
                moveTo(13.5f, 10.26f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(1.12f)
                horizontalLineToRelative(2.5f)
                verticalLineToRelative(1.26f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(1.11f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(10.26f)
                close()
                moveTo(20.5f, 14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.25f)
                verticalLineToRelative(4.51f)
                horizontalLineToRelative(1.13f)
                verticalLineTo(9.99f)
                horizontalLineToRelative(1.25f)
                verticalLineToRelative(3.51f)
                horizontalLineToRelative(1.12f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.25f)
                verticalLineTo(14.0f)
                close()
            }
        }
        return _fiberNew!!
    }

private var _fiberNew: ImageVector? = null
