/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PublishedWithChanges: ImageVector
    get() {
        if (_publishedWithChanges != null) {
            return _publishedWithChanges!!
        }
        _publishedWithChanges = materialIcon(name = "Filled.PublishedWithChanges") {
            materialPath {
                moveTo(17.66f, 9.53f)
                lineToRelative(-7.07f, 7.07f)
                lineToRelative(-4.24f, -4.24f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(2.83f, 2.83f)
                lineToRelative(5.66f, -5.66f)
                lineTo(17.66f, 9.53f)
                close()
                moveTo(4.0f, 12.0f)
                curveToRelative(0.0f, -2.33f, 1.02f, -4.42f, 2.62f, -5.88f)
                lineTo(9.0f, 8.5f)
                verticalLineToRelative(-6.0f)
                horizontalLineTo(3.0f)
                lineToRelative(2.2f, 2.2f)
                curveTo(3.24f, 6.52f, 2.0f, 9.11f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.19f, 3.95f, 9.45f, 9.0f, 9.95f)
                verticalLineToRelative(-2.02f)
                curveTo(7.06f, 19.44f, 4.0f, 16.07f, 4.0f, 12.0f)
                close()
                moveTo(22.0f, 12.0f)
                curveToRelative(0.0f, -5.19f, -3.95f, -9.45f, -9.0f, -9.95f)
                verticalLineToRelative(2.02f)
                curveToRelative(3.94f, 0.49f, 7.0f, 3.86f, 7.0f, 7.93f)
                curveToRelative(0.0f, 2.33f, -1.02f, 4.42f, -2.62f, 5.88f)
                lineTo(15.0f, 15.5f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(6.0f)
                lineToRelative(-2.2f, -2.2f)
                curveTo(20.76f, 17.48f, 22.0f, 14.89f, 22.0f, 12.0f)
                close()
            }
        }
        return _publishedWithChanges!!
    }

private var _publishedWithChanges: ImageVector? = null
