/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Groups3: ImageVector
    get() {
        if (_groups3 != null) {
            return _groups3!!
        }
        _groups3 = materialIcon(name = "Outlined.Groups3") {
            materialPath {
                moveTo(16.24f, 13.65f)
                curveToRelative(-1.17f, -0.52f, -2.61f, -0.9f, -4.24f, -0.9f)
                curveToRelative(-1.63f, 0.0f, -3.07f, 0.39f, -4.24f, 0.9f)
                curveTo(6.68f, 14.13f, 6.0f, 15.21f, 6.0f, 16.39f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-1.61f)
                curveTo(18.0f, 15.21f, 17.32f, 14.13f, 16.24f, 13.65f)
                close()
                moveTo(8.07f, 16.0f)
                curveToRelative(0.09f, -0.23f, 0.27f, -0.42f, 0.49f, -0.52f)
                curveToRelative(1.1f, -0.49f, 2.26f, -0.73f, 3.43f, -0.73f)
                curveToRelative(1.18f, 0.0f, 2.33f, 0.25f, 3.43f, 0.73f)
                curveToRelative(0.23f, 0.1f, 0.4f, 0.29f, 0.49f, 0.52f)
                horizontalLineTo(8.07f)
                close()
            }
            materialPath {
                moveTo(1.22f, 14.58f)
                curveTo(0.48f, 14.9f, 0.0f, 15.62f, 0.0f, 16.43f)
                verticalLineTo(18.0f)
                lineToRelative(4.5f, 0.0f)
                verticalLineToRelative(-1.61f)
                curveToRelative(0.0f, -0.83f, 0.23f, -1.61f, 0.63f, -2.29f)
                curveTo(4.76f, 14.04f, 4.39f, 14.0f, 4.0f, 14.0f)
                curveTo(3.01f, 14.0f, 2.07f, 14.21f, 1.22f, 14.58f)
                close()
            }
            materialPath {
                moveTo(22.78f, 14.58f)
                curveTo(21.93f, 14.21f, 20.99f, 14.0f, 20.0f, 14.0f)
                curveToRelative(-0.39f, 0.0f, -0.76f, 0.04f, -1.13f, 0.1f)
                curveToRelative(0.4f, 0.68f, 0.63f, 1.46f, 0.63f, 2.29f)
                verticalLineTo(18.0f)
                lineToRelative(4.5f, 0.0f)
                verticalLineToRelative(-1.57f)
                curveTo(24.0f, 15.62f, 23.52f, 14.9f, 22.78f, 14.58f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(9.0f, 7.34f, 9.0f, 9.0f)
                curveTo(9.0f, 10.66f, 10.34f, 12.0f, 12.0f, 12.0f)
                close()
                moveTo(12.0f, 8.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveTo(11.45f, 8.0f, 12.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(1.497f, 11.0f)
                lineToRelative(2.503f, -2.503f)
                lineToRelative(2.503f, 2.503f)
                lineToRelative(-2.503f, 2.503f)
                close()
            }
            materialPath {
                moveTo(20.0f, 9.0f)
                lineToRelative(-2.5f, 4.0f)
                lineToRelative(5.0f, 0.0f)
                close()
            }
        }
        return _groups3!!
    }

private var _groups3: ImageVector? = null
