/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Outlined.LastPage",
    ReplaceWith( "Icons.AutoMirrored.Outlined.LastPage",
            "androidx.compose.material.icons.automirrored.outlined.LastPage"),
)
public val Icons.Outlined.LastPage: ImageVector
    get() {
        if (_lastPage != null) {
            return _lastPage!!
        }
        _lastPage = materialIcon(name = "Outlined.LastPage") {
            materialPath {
                moveTo(5.59f, 7.41f)
                lineTo(10.18f, 12.0f)
                lineToRelative(-4.59f, 4.59f)
                lineTo(7.0f, 18.0f)
                lineToRelative(6.0f, -6.0f)
                lineToRelative(-6.0f, -6.0f)
                lineToRelative(-1.41f, 1.41f)
                close()
                moveTo(16.0f, 6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(6.0f)
                close()
            }
        }
        return _lastPage!!
    }

private var _lastPage: ImageVector? = null
