/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PostAdd: ImageVector
    get() {
        if (_postAdd != null) {
            return _postAdd!!
        }
        _postAdd = materialIcon(name = "Rounded.PostAdd") {
            materialPath {
                moveTo(18.0f, 12.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(5.22f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 5.0f, 3.0f, 5.9f, 3.0f, 7.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-6.0f)
                curveTo(19.0f, 12.45f, 18.55f, 12.0f, 18.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(21.02f, 5.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(2.98f)
                curveTo(19.0f, 2.44f, 18.56f, 2.0f, 18.02f, 2.0f)
                horizontalLineToRelative(-0.03f)
                curveTo(17.44f, 2.0f, 17.0f, 2.44f, 17.0f, 2.98f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-2.01f)
                curveTo(14.45f, 5.0f, 14.01f, 5.44f, 14.0f, 5.98f)
                curveToRelative(0.0f, 0.01f, 0.0f, 0.02f, 0.0f, 0.03f)
                curveTo(14.0f, 6.56f, 14.44f, 7.0f, 14.99f, 7.0f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(2.01f)
                curveToRelative(0.0f, 0.54f, 0.44f, 0.99f, 0.99f, 0.98f)
                curveToRelative(0.01f, 0.0f, 0.02f, 0.0f, 0.03f, 0.0f)
                curveToRelative(0.54f, 0.0f, 0.98f, -0.44f, 0.98f, -0.98f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.02f)
                curveTo(21.56f, 7.0f, 22.0f, 6.56f, 22.0f, 6.02f)
                verticalLineTo(5.98f)
                curveTo(22.0f, 5.44f, 21.56f, 5.0f, 21.02f, 5.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 9.0f)
                horizontalLineTo(8.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveTo(15.0f, 9.45f, 14.55f, 9.0f, 14.0f, 9.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 12.0f)
                horizontalLineTo(8.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveTo(15.0f, 12.45f, 14.55f, 12.0f, 14.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 15.0f)
                horizontalLineTo(8.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveTo(15.0f, 15.45f, 14.55f, 15.0f, 14.0f, 15.0f)
                close()
            }
        }
        return _postAdd!!
    }

private var _postAdd: ImageVector? = null
