/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RMobiledata: ImageVector
    get() {
        if (_rMobiledata != null) {
            return _rMobiledata!!
        }
        _rMobiledata = materialIcon(name = "Rounded.RMobiledata") {
            materialPath {
                moveTo(7.8f, 7.2f)
                lineToRelative(0.65f, 1.52f)
                curveTo(8.71f, 9.33f, 8.27f, 10.0f, 7.61f, 10.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.37f, 0.0f, -0.7f, -0.22f, -0.85f, -0.56f)
                lineTo(5.87f, 7.33f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(1.75f)
                curveTo(4.0f, 9.59f, 3.59f, 10.0f, 3.08f, 10.0f)
                horizontalLineTo(2.92f)
                curveTo(2.41f, 10.0f, 2.0f, 9.59f, 2.0f, 9.08f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(1.33f)
                curveTo(9.0f, 6.13f, 8.47f, 6.87f, 7.8f, 7.2f)
                close()
                moveTo(7.0f, 4.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(1.33f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(4.0f)
                close()
            }
        }
        return _rMobiledata!!
    }

private var _rMobiledata: ImageVector? = null
