/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AmpStories: ImageVector
    get() {
        if (_ampStories != null) {
            return _ampStories!!
        }
        _ampStories = materialIcon(name = "Filled.AmpStories") {
            materialPath {
                moveTo(7.0f, 4.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(15.0f)
                horizontalLineToRelative(-10.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
        }
        return _ampStories!!
    }

private var _ampStories: ImageVector? = null
