/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Tram: ImageVector
    get() {
        if (_tram != null) {
            return _tram!!
        }
        _tram = materialIcon(name = "Outlined.Tram") {
            materialPath {
                moveTo(13.0f, 5.0f)
                lineToRelative(0.75f, -1.5f)
                lineTo(17.0f, 3.5f)
                lineTo(17.0f, 2.0f)
                lineTo(7.0f, 2.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(4.75f)
                lineTo(11.0f, 5.0f)
                curveToRelative(-3.13f, 0.09f, -6.0f, 0.73f, -6.0f, 3.5f)
                lineTo(5.0f, 17.0f)
                curveToRelative(0.0f, 1.5f, 1.11f, 2.73f, 2.55f, 2.95f)
                lineTo(6.0f, 21.5f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(2.0f)
                lineToRelative(2.0f, -2.0f)
                horizontalLineToRelative(4.0f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-0.5f)
                lineToRelative(-1.55f, -1.55f)
                horizontalLineToRelative(-0.01f)
                horizontalLineToRelative(0.01f)
                curveTo(17.89f, 19.73f, 19.0f, 18.5f, 19.0f, 17.0f)
                lineTo(19.0f, 8.5f)
                curveToRelative(0.0f, -2.77f, -2.87f, -3.41f, -6.0f, -3.5f)
                close()
                moveTo(11.03f, 7.0f)
                horizontalLineToRelative(1.94f)
                curveToRelative(2.75f, 0.08f, 3.62f, 0.58f, 3.9f, 1.0f)
                lineTo(7.13f, 8.0f)
                curveToRelative(0.28f, -0.42f, 1.15f, -0.92f, 3.9f, -1.0f)
                close()
                moveTo(10.85f, 17.95f)
                lineTo(7.74f, 17.95f)
                curveTo(7.3f, 17.84f, 7.0f, 17.45f, 7.0f, 17.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(3.89f)
                curveToRelative(-0.24f, 0.27f, -0.39f, 0.61f, -0.39f, 1.0f)
                curveToRelative(0.0f, 0.36f, 0.13f, 0.69f, 0.35f, 0.95f)
                close()
                moveTo(17.0f, 17.0f)
                curveToRelative(0.0f, 0.45f, -0.3f, 0.84f, -0.74f, 0.95f)
                horizontalLineToRelative(-3.11f)
                curveToRelative(0.22f, -0.26f, 0.35f, -0.59f, 0.35f, -0.95f)
                curveToRelative(0.0f, -0.39f, -0.15f, -0.73f, -0.39f, -1.0f)
                lineTo(17.0f, 16.0f)
                verticalLineToRelative(1.0f)
                close()
                moveTo(17.0f, 14.0f)
                lineTo(7.0f, 14.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(4.0f)
                close()
            }
        }
        return _tram!!
    }

private var _tram: ImageVector? = null
