/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DonutLarge: ImageVector
    get() {
        if (_donutLarge != null) {
            return _donutLarge!!
        }
        _donutLarge = materialIcon(name = "Rounded.DonutLarge") {
            materialPath {
                moveTo(14.07f, 5.32f)
                curveTo(16.26f, 6.0f, 18.0f, 7.74f, 18.68f, 9.93f)
                curveToRelative(0.19f, 0.63f, 0.76f, 1.07f, 1.41f, 1.07f)
                horizontalLineToRelative(0.04f)
                curveToRelative(1.0f, 0.0f, 1.72f, -0.96f, 1.43f, -1.91f)
                curveToRelative(-0.97f, -3.18f, -3.48f, -5.69f, -6.66f, -6.66f)
                curveToRelative(-0.94f, -0.29f, -1.9f, 0.43f, -1.9f, 1.43f)
                verticalLineToRelative(0.04f)
                curveToRelative(0.0f, 0.66f, 0.44f, 1.23f, 1.07f, 1.42f)
                close()
                moveTo(18.68f, 14.07f)
                curveToRelative(-0.68f, 2.2f, -2.42f, 3.93f, -4.61f, 4.61f)
                curveToRelative(-0.63f, 0.19f, -1.07f, 0.76f, -1.07f, 1.41f)
                verticalLineToRelative(0.04f)
                curveToRelative(0.0f, 1.0f, 0.96f, 1.72f, 1.91f, 1.43f)
                curveToRelative(3.18f, -0.97f, 5.69f, -3.48f, 6.66f, -6.66f)
                curveToRelative(0.29f, -0.95f, -0.43f, -1.91f, -1.42f, -1.91f)
                horizontalLineToRelative(-0.05f)
                curveToRelative(-0.66f, 0.01f, -1.23f, 0.45f, -1.42f, 1.08f)
                close()
                moveTo(11.0f, 20.11f)
                curveToRelative(0.0f, -0.67f, -0.45f, -1.24f, -1.09f, -1.44f)
                curveTo(7.07f, 17.78f, 5.0f, 15.13f, 5.0f, 12.0f)
                reflectiveCurveToRelative(2.07f, -5.78f, 4.91f, -6.67f)
                curveToRelative(0.64f, -0.2f, 1.09f, -0.77f, 1.09f, -1.44f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.0f, -1.0f, -0.97f, -1.74f, -1.93f, -1.44f)
                curveTo(4.98f, 3.69f, 2.0f, 7.5f, 2.0f, 12.0f)
                curveToRelative(0.0f, 4.5f, 2.98f, 8.31f, 7.07f, 9.56f)
                curveToRelative(0.96f, 0.3f, 1.93f, -0.44f, 1.93f, -1.45f)
                close()
            }
        }
        return _donutLarge!!
    }

private var _donutLarge: ImageVector? = null
