/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FormatColorReset: ImageVector
    get() {
        if (_formatColorReset != null) {
            return _formatColorReset!!
        }
        _formatColorReset = materialIcon(name = "Sharp.FormatColorReset") {
            materialPath {
                moveTo(18.0f, 14.0f)
                curveToRelative(0.0f, -3.98f, -6.0f, -10.8f, -6.0f, -10.8f)
                reflectiveCurveToRelative(-1.18f, 1.35f, -2.5f, 3.19f)
                lineToRelative(8.44f, 8.44f)
                curveToRelative(0.03f, -0.27f, 0.06f, -0.55f, 0.06f, -0.83f)
                close()
                moveTo(5.41f, 5.14f)
                lineTo(4.0f, 6.55f)
                lineToRelative(3.32f, 3.32f)
                curveTo(6.55f, 11.33f, 6.0f, 12.79f, 6.0f, 14.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                curveToRelative(1.52f, 0.0f, 2.9f, -0.57f, 3.95f, -1.5f)
                lineToRelative(2.63f, 2.63f)
                lineTo(20.0f, 19.72f)
                lineTo(5.41f, 5.14f)
                close()
            }
        }
        return _formatColorReset!!
    }

private var _formatColorReset: ImageVector? = null
