/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Commute: ImageVector
    get() {
        if (_commute != null) {
            return _commute!!
        }
        _commute = materialIcon(name = "TwoTone.Commute") {
            materialPath {
                moveTo(12.0f, 4.0f)
                lineTo(5.0f, 4.0f)
                curveTo(3.34f, 4.0f, 2.0f, 5.34f, 2.0f, 7.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                lineToRelative(-1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(2.0f, -2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-5.0f)
                lineTo(4.0f, 13.0f)
                lineTo(4.0f, 6.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                lineTo(15.0f, 7.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                close()
                moveTo(5.0f, 14.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                close()
                moveTo(20.57f, 9.66f)
                curveToRelative(-0.14f, -0.4f, -0.52f, -0.66f, -0.97f, -0.66f)
                horizontalLineToRelative(-7.19f)
                curveToRelative(-0.46f, 0.0f, -0.83f, 0.26f, -0.98f, 0.66f)
                lineToRelative(-1.42f, 4.11f)
                verticalLineToRelative(5.51f)
                curveToRelative(0.0f, 0.38f, 0.31f, 0.72f, 0.69f, 0.72f)
                horizontalLineToRelative(0.62f)
                curveToRelative(0.38f, 0.0f, 0.68f, -0.38f, 0.68f, -0.76f)
                lineTo(12.0f, 18.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(1.24f)
                curveToRelative(0.0f, 0.38f, 0.31f, 0.76f, 0.69f, 0.76f)
                horizontalLineToRelative(0.61f)
                curveToRelative(0.38f, 0.0f, 0.69f, -0.34f, 0.69f, -0.72f)
                lineToRelative(0.01f, -1.37f)
                verticalLineToRelative(-4.14f)
                lineToRelative(-1.43f, -4.11f)
                close()
                moveTo(12.41f, 10.0f)
                horizontalLineToRelative(7.19f)
                lineToRelative(1.03f, 3.0f)
                horizontalLineToRelative(-9.25f)
                lineToRelative(1.03f, -3.0f)
                close()
                moveTo(12.0f, 16.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                close()
                moveTo(20.0f, 16.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                close()
            }
        }
        return _commute!!
    }

private var _commute: ImageVector? = null
