/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Emergency: ImageVector
    get() {
        if (_emergency != null) {
            return _emergency!!
        }
        _emergency = materialIcon(name = "TwoTone.Emergency") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.43f, 16.87f)
                lineToRelative(-4.68f, -2.7f)
                curveTo(13.42f, 13.97f, 13.0f, 14.21f, 13.0f, 14.6f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-5.4f)
                curveToRelative(0.0f, -0.38f, -0.42f, -0.63f, -0.75f, -0.43f)
                lineToRelative(-4.68f, 2.7f)
                lineToRelative(-1.0f, -1.73f)
                lineToRelative(4.68f, -2.7f)
                curveToRelative(0.33f, -0.19f, 0.33f, -0.67f, 0.0f, -0.87f)
                lineToRelative(-4.68f, -2.7f)
                lineToRelative(1.0f, -1.73f)
                lineToRelative(4.68f, 2.7f)
                curveTo(10.58f, 10.03f, 11.0f, 9.79f, 11.0f, 9.4f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.4f)
                curveToRelative(0.0f, 0.38f, 0.42f, 0.63f, 0.75f, 0.43f)
                lineToRelative(4.68f, -2.7f)
                lineToRelative(1.0f, 1.73f)
                lineToRelative(-4.68f, 2.7f)
                curveToRelative(-0.33f, 0.19f, -0.33f, 0.67f, 0.0f, 0.87f)
                lineToRelative(4.68f, 2.7f)
                lineTo(18.43f, 16.87f)
                close()
            }
            materialPath {
                moveTo(21.29f, 13.9f)
                lineTo(18.0f, 12.0f)
                lineToRelative(3.29f, -1.9f)
                curveToRelative(0.48f, -0.28f, 0.64f, -0.89f, 0.37f, -1.37f)
                lineToRelative(-2.0f, -3.46f)
                curveToRelative(-0.28f, -0.48f, -0.89f, -0.64f, -1.37f, -0.37f)
                lineTo(15.0f, 6.8f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(9.45f, 2.0f, 9.0f, 2.45f, 9.0f, 3.0f)
                verticalLineToRelative(3.8f)
                lineTo(5.71f, 4.9f)
                curveTo(5.23f, 4.63f, 4.62f, 4.79f, 4.34f, 5.27f)
                lineToRelative(-2.0f, 3.46f)
                curveTo(2.06f, 9.21f, 2.23f, 9.82f, 2.71f, 10.1f)
                lineTo(6.0f, 12.0f)
                lineToRelative(-3.29f, 1.9f)
                curveToRelative(-0.48f, 0.28f, -0.64f, 0.89f, -0.37f, 1.37f)
                lineToRelative(2.0f, 3.46f)
                curveToRelative(0.28f, 0.48f, 0.89f, 0.64f, 1.37f, 0.37f)
                lineTo(9.0f, 17.2f)
                verticalLineTo(21.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.8f)
                lineToRelative(3.29f, 1.9f)
                curveToRelative(0.48f, 0.28f, 1.09f, 0.11f, 1.37f, -0.37f)
                lineToRelative(2.0f, -3.46f)
                curveTo(21.94f, 14.79f, 21.77f, 14.18f, 21.29f, 13.9f)
                close()
                moveTo(18.43f, 16.87f)
                lineToRelative(-4.68f, -2.7f)
                curveTo(13.42f, 13.97f, 13.0f, 14.21f, 13.0f, 14.6f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-5.4f)
                curveToRelative(0.0f, -0.38f, -0.42f, -0.63f, -0.75f, -0.43f)
                lineToRelative(-4.68f, 2.7f)
                lineToRelative(-1.0f, -1.73f)
                lineToRelative(4.68f, -2.7f)
                curveToRelative(0.33f, -0.19f, 0.33f, -0.67f, 0.0f, -0.87f)
                lineToRelative(-4.68f, -2.7f)
                lineToRelative(1.0f, -1.73f)
                lineToRelative(4.68f, 2.7f)
                curveTo(10.58f, 10.03f, 11.0f, 9.79f, 11.0f, 9.4f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.4f)
                curveToRelative(0.0f, 0.38f, 0.42f, 0.63f, 0.75f, 0.43f)
                lineToRelative(4.68f, -2.7f)
                lineToRelative(1.0f, 1.73f)
                lineToRelative(-4.68f, 2.7f)
                curveToRelative(-0.33f, 0.19f, -0.33f, 0.67f, 0.0f, 0.87f)
                lineToRelative(4.68f, 2.7f)
                lineTo(18.43f, 16.87f)
                close()
            }
        }
        return _emergency!!
    }

private var _emergency: ImageVector? = null
