/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.TwoTone.OfflineShare",
    ReplaceWith( "Icons.AutoMirrored.TwoTone.OfflineShare",
            "androidx.compose.material.icons.automirrored.twotone.OfflineShare"),
)
public val Icons.TwoTone.OfflineShare: ImageVector
    get() {
        if (_offlineShare != null) {
            return _offlineShare!!
        }
        _offlineShare = materialIcon(name = "TwoTone.OfflineShare") {
            materialPath {
                moveTo(6.0f, 5.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(5.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 1.0f)
                horizontalLineToRelative(-8.0f)
                curveTo(8.9f, 1.0f, 8.0f, 1.9f, 8.0f, 3.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(20.0f, 1.9f, 19.1f, 1.0f, 18.0f, 1.0f)
                close()
                moveTo(18.0f, 17.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(18.0f, 14.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(14.0f)
                close()
                moveTo(18.0f, 4.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(12.5f, 10.25f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(12.0f)
                lineTo(17.0f, 9.5f)
                lineTo(14.5f, 7.0f)
                verticalLineToRelative(1.75f)
                horizontalLineTo(12.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(10.25f)
                close()
            }
        }
        return _offlineShare!!
    }

private var _offlineShare: ImageVector? = null
