/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Polyline: ImageVector
    get() {
        if (_polyline != null) {
            return _polyline!!
        }
        _polyline = materialIcon(name = "Filled.Polyline") {
            materialPath {
                moveTo(15.0f, 16.0f)
                lineToRelative(0.0f, 1.26f)
                lineToRelative(-6.0f, -3.0f)
                lineToRelative(0.0f, -3.17f)
                lineToRelative(2.7f, -3.09f)
                lineToRelative(4.3f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(-6.0f, 0.0f)
                lineToRelative(0.0f, 4.9f)
                lineToRelative(-2.7f, 3.1f)
                lineToRelative(-4.3f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(7.0f, 3.5f)
                lineToRelative(0.0f, 2.5f)
                lineToRelative(6.0f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                close()
            }
        }
        return _polyline!!
    }

private var _polyline: ImageVector? = null
