/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PortableWifiOff: ImageVector
    get() {
        if (_portableWifiOff != null) {
            return _portableWifiOff!!
        }
        _portableWifiOff = materialIcon(name = "Filled.PortableWifiOff") {
            materialPath {
                moveTo(17.56f, 14.24f)
                curveToRelative(0.28f, -0.69f, 0.44f, -1.45f, 0.44f, -2.24f)
                curveToRelative(0.0f, -3.31f, -2.69f, -6.0f, -6.0f, -6.0f)
                curveToRelative(-0.79f, 0.0f, -1.55f, 0.16f, -2.24f, 0.44f)
                lineToRelative(1.62f, 1.62f)
                curveToRelative(0.2f, -0.03f, 0.41f, -0.06f, 0.62f, -0.06f)
                curveToRelative(2.21f, 0.0f, 4.0f, 1.79f, 4.0f, 4.0f)
                curveToRelative(0.0f, 0.21f, -0.02f, 0.42f, -0.05f, 0.63f)
                lineToRelative(1.61f, 1.61f)
                close()
                moveTo(12.0f, 4.0f)
                curveToRelative(4.42f, 0.0f, 8.0f, 3.58f, 8.0f, 8.0f)
                curveToRelative(0.0f, 1.35f, -0.35f, 2.62f, -0.95f, 3.74f)
                lineToRelative(1.47f, 1.47f)
                curveTo(21.46f, 15.69f, 22.0f, 13.91f, 22.0f, 12.0f)
                curveToRelative(0.0f, -5.52f, -4.48f, -10.0f, -10.0f, -10.0f)
                curveToRelative(-1.91f, 0.0f, -3.69f, 0.55f, -5.21f, 1.47f)
                lineToRelative(1.46f, 1.46f)
                curveTo(9.37f, 4.34f, 10.65f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(3.27f, 2.5f)
                lineTo(2.0f, 3.77f)
                lineToRelative(2.1f, 2.1f)
                curveTo(2.79f, 7.57f, 2.0f, 9.69f, 2.0f, 12.0f)
                curveToRelative(0.0f, 3.7f, 2.01f, 6.92f, 4.99f, 8.65f)
                lineToRelative(1.0f, -1.73f)
                curveTo(5.61f, 17.53f, 4.0f, 14.96f, 4.0f, 12.0f)
                curveToRelative(0.0f, -1.76f, 0.57f, -3.38f, 1.53f, -4.69f)
                lineToRelative(1.43f, 1.44f)
                curveTo(6.36f, 9.68f, 6.0f, 10.8f, 6.0f, 12.0f)
                curveToRelative(0.0f, 2.22f, 1.21f, 4.15f, 3.0f, 5.19f)
                lineToRelative(1.0f, -1.74f)
                curveToRelative(-1.19f, -0.7f, -2.0f, -1.97f, -2.0f, -3.45f)
                curveToRelative(0.0f, -0.65f, 0.17f, -1.25f, 0.44f, -1.79f)
                lineToRelative(1.58f, 1.58f)
                lineTo(10.0f, 12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                lineToRelative(0.21f, -0.02f)
                lineToRelative(0.01f, 0.01f)
                lineToRelative(7.51f, 7.51f)
                lineTo(21.0f, 20.23f)
                lineTo(4.27f, 3.5f)
                lineToRelative(-1.0f, -1.0f)
                close()
            }
        }
        return _portableWifiOff!!
    }

private var _portableWifiOff: ImageVector? = null
