/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SmokingRooms: ImageVector
    get() {
        if (_smokingRooms != null) {
            return _smokingRooms!!
        }
        _smokingRooms = materialIcon(name = "Sharp.SmokingRooms") {
            materialPath {
                moveTo(2.0f, 16.0f)
                horizontalLineToRelative(15.0f)
                verticalLineToRelative(3.0f)
                lineTo(2.0f, 19.0f)
                verticalLineToRelative(-3.0f)
                close()
                moveTo(20.5f, 16.0f)
                lineTo(22.0f, 16.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-3.0f)
                close()
                moveTo(18.0f, 16.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(3.0f)
                lineTo(18.0f, 19.0f)
                verticalLineToRelative(-3.0f)
                close()
                moveTo(18.85f, 7.73f)
                curveToRelative(0.62f, -0.61f, 1.0f, -1.45f, 1.0f, -2.38f)
                curveTo(19.85f, 3.5f, 18.35f, 2.0f, 16.5f, 2.0f)
                verticalLineToRelative(1.5f)
                curveToRelative(1.02f, 0.0f, 1.85f, 0.83f, 1.85f, 1.85f)
                reflectiveCurveTo(17.52f, 7.2f, 16.5f, 7.2f)
                verticalLineToRelative(1.5f)
                curveToRelative(2.24f, 0.0f, 4.0f, 1.83f, 4.0f, 4.07f)
                lineTo(20.5f, 15.0f)
                lineTo(22.0f, 15.0f)
                verticalLineToRelative(-2.24f)
                curveToRelative(0.0f, -2.22f, -1.28f, -4.14f, -3.15f, -5.03f)
                close()
                moveTo(16.03f, 10.2f)
                lineTo(14.5f, 10.2f)
                curveToRelative(-1.02f, 0.0f, -1.85f, -0.98f, -1.85f, -2.0f)
                reflectiveCurveToRelative(0.83f, -1.75f, 1.85f, -1.75f)
                verticalLineToRelative(-1.5f)
                curveToRelative(-1.85f, 0.0f, -3.35f, 1.5f, -3.35f, 3.35f)
                reflectiveCurveToRelative(1.5f, 3.35f, 3.35f, 3.35f)
                horizontalLineToRelative(1.53f)
                curveToRelative(1.05f, 0.0f, 1.97f, 0.74f, 1.97f, 2.05f)
                lineTo(18.0f, 15.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-1.64f)
                curveToRelative(0.0f, -1.81f, -1.6f, -3.16f, -3.47f, -3.16f)
                close()
            }
        }
        return _smokingRooms!!
    }

private var _smokingRooms: ImageVector? = null
