/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TurnSharpRight: ImageVector
    get() {
        if (_turnSharpRight != null) {
            return _turnSharpRight!!
        }
        _turnSharpRight = materialIcon(name = "Sharp.TurnSharpRight") {
            materialPath {
                moveTo(18.0f, 6.83f)
                lineToRelative(1.59f, 1.58f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-4.0f, 4.0f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.59f, -1.58f)
                lineToRelative(0.0f, 6.17f)
                lineToRelative(-10.0f, 0.0f)
                lineToRelative(0.0f, 8.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(10.0f, 0.0f)
                close()
            }
        }
        return _turnSharpRight!!
    }

private var _turnSharpRight: ImageVector? = null
