/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.DoDisturbOff: ImageVector
    get() {
        if (_doDisturbOff != null) {
            return _doDisturbOff!!
        }
        _doDisturbOff = materialIcon(name = "TwoTone.DoDisturbOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.0f)
                curveToRelative(-1.41f, 0.0f, -2.73f, 0.37f, -3.88f, 1.01f)
                lineToRelative(6.0f, 5.99f)
                lineTo(17.0f, 11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-0.88f)
                lineTo(19.0f, 15.88f)
                curveToRelative(0.63f, -1.15f, 1.0f, -2.47f, 1.0f, -3.88f)
                curveToRelative(0.0f, -4.41f, -3.59f, -8.0f, -8.0f, -8.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(1.56f, 0.0f, 3.0f, -0.45f, 4.23f, -1.23f)
                lineTo(10.46f, 13.0f)
                lineTo(7.0f, 13.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.46f)
                lineTo(5.23f, 7.77f)
                curveTo(4.45f, 9.0f, 4.0f, 10.44f, 4.0f, 12.0f)
                curveToRelative(0.0f, 4.41f, 3.59f, 8.0f, 8.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                curveToRelative(4.41f, 0.0f, 8.0f, 3.59f, 8.0f, 8.0f)
                curveToRelative(0.0f, 1.41f, -0.37f, 2.73f, -1.01f, 3.88f)
                lineToRelative(1.46f, 1.46f)
                curveTo(21.43f, 15.79f, 22.0f, 13.96f, 22.0f, 12.0f)
                curveToRelative(0.0f, -5.52f, -4.48f, -10.0f, -10.0f, -10.0f)
                curveToRelative(-1.96f, 0.0f, -3.79f, 0.57f, -5.33f, 1.55f)
                lineToRelative(1.46f, 1.46f)
                curveTo(9.27f, 4.37f, 10.59f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(17.0f, 11.0f)
                horizontalLineToRelative(-2.88f)
                lineToRelative(2.0f, 2.0f)
                lineTo(17.0f, 13.0f)
                close()
                moveTo(2.41f, 2.13f)
                lineTo(1.0f, 3.54f)
                lineToRelative(2.78f, 2.78f)
                curveTo(2.66f, 7.93f, 2.0f, 9.89f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                curveToRelative(2.11f, 0.0f, 4.07f, -0.66f, 5.68f, -1.78f)
                lineTo(20.46f, 23.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.41f, 2.13f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -1.56f, 0.45f, -3.0f, 1.23f, -4.23f)
                lineTo(8.46f, 11.0f)
                lineTo(7.0f, 11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.46f)
                lineToRelative(5.77f, 5.77f)
                curveTo(15.0f, 19.55f, 13.56f, 20.0f, 12.0f, 20.0f)
                close()
            }
        }
        return _doDisturbOff!!
    }

private var _doDisturbOff: ImageVector? = null
