/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.TransitEnterexit: ImageVector
    get() {
        if (_transitEnterexit != null) {
            return _transitEnterexit!!
        }
        _transitEnterexit = materialIcon(name = "Outlined.TransitEnterexit") {
            materialPath {
                moveTo(16.0f, 18.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(4.77f)
                lineTo(15.98f, 6.0f)
                lineTo(18.0f, 8.03f)
                lineTo(11.15f, 15.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(3.0f)
                close()
            }
        }
        return _transitEnterexit!!
    }

private var _transitEnterexit: ImageVector? = null
