/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.VoiceOverOff: ImageVector
    get() {
        if (_voiceOverOff != null) {
            return _voiceOverOff!!
        }
        _voiceOverOff = materialIcon(name = "Outlined.VoiceOverOff") {
            materialPath {
                moveTo(16.76f, 5.36f)
                lineToRelative(-1.68f, 1.69f)
                curveToRelative(0.8f, 1.13f, 0.83f, 2.58f, 0.09f, 3.74f)
                lineToRelative(1.7f, 1.7f)
                curveToRelative(1.9f, -2.02f, 1.87f, -4.98f, -0.11f, -7.13f)
                close()
                moveTo(20.07f, 2.0f)
                lineToRelative(-1.63f, 1.63f)
                curveToRelative(2.72f, 2.97f, 2.76f, 7.39f, 0.14f, 10.56f)
                lineToRelative(1.64f, 1.64f)
                curveToRelative(3.74f, -3.89f, 3.71f, -9.84f, -0.15f, -13.83f)
                close()
                moveTo(9.43f, 5.04f)
                lineToRelative(3.53f, 3.53f)
                curveToRelative(-0.2f, -1.86f, -1.67f, -3.33f, -3.53f, -3.53f)
                close()
                moveTo(4.41f, 2.86f)
                lineTo(3.0f, 4.27f)
                lineToRelative(2.62f, 2.62f)
                curveTo(5.23f, 7.5f, 5.0f, 8.22f, 5.0f, 9.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                curveToRelative(0.78f, 0.0f, 1.5f, -0.23f, 2.11f, -0.62f)
                lineToRelative(4.4f, 4.4f)
                curveTo(13.74f, 15.6f, 10.78f, 15.0f, 9.0f, 15.0f)
                curveToRelative(-2.67f, 0.0f, -8.0f, 1.34f, -8.0f, 4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.37f, -0.11f, -0.7f, -0.29f, -1.02f)
                lineTo(19.73f, 21.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(4.41f, 2.86f)
                close()
                moveTo(3.0f, 19.0f)
                curveToRelative(0.22f, -0.72f, 3.31f, -2.0f, 6.0f, -2.0f)
                curveToRelative(2.7f, 0.0f, 5.8f, 1.29f, 6.0f, 2.0f)
                lineTo(3.0f, 19.0f)
                close()
                moveTo(9.0f, 11.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -0.22f, 0.04f, -0.42f, 0.11f, -0.62f)
                lineToRelative(2.51f, 2.51f)
                curveToRelative(-0.2f, 0.07f, -0.4f, 0.11f, -0.62f, 0.11f)
                close()
            }
        }
        return _voiceOverOff!!
    }

private var _voiceOverOff: ImageVector? = null
