/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AssuredWorkload: ImageVector
    get() {
        if (_assuredWorkload != null) {
            return _assuredWorkload!!
        }
        _assuredWorkload = materialIcon(name = "Rounded.AssuredWorkload") {
            materialPath {
                moveTo(6.0f, 17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-5.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(5.0f)
                curveTo(5.0f, 16.55f, 5.45f, 17.0f, 6.0f, 17.0f)
                lineTo(6.0f, 17.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-5.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(5.0f)
                curveTo(11.0f, 16.55f, 11.45f, 17.0f, 12.0f, 17.0f)
                lineTo(12.0f, 17.0f)
                close()
            }
            materialPath {
                moveTo(21.32f, 5.66f)
                lineToRelative(-8.42f, -4.21f)
                curveToRelative(-0.56f, -0.28f, -1.23f, -0.28f, -1.79f, 0.0f)
                lineTo(2.68f, 5.66f)
                curveTo(2.26f, 5.87f, 2.0f, 6.3f, 2.0f, 6.76f)
                verticalLineToRelative(0.0f)
                curveTo(2.0f, 7.45f, 2.55f, 8.0f, 3.24f, 8.0f)
                horizontalLineToRelative(17.53f)
                curveTo(21.45f, 8.0f, 22.0f, 7.45f, 22.0f, 6.76f)
                verticalLineToRelative(0.0f)
                curveTo(22.0f, 6.3f, 21.74f, 5.87f, 21.32f, 5.66f)
                close()
            }
            materialPath {
                moveTo(2.0f, 20.0f)
                lineTo(2.0f, 20.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(11.4f)
                curveToRelative(-0.21f, -0.64f, -0.32f, -1.31f, -0.36f, -2.0f)
                horizontalLineTo(3.0f)
                curveTo(2.45f, 19.0f, 2.0f, 19.45f, 2.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 12.26f)
                verticalLineTo(11.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.26f)
                lineTo(19.0f, 12.26f)
                close()
            }
            materialPath {
                moveTo(19.55f, 14.22f)
                lineToRelative(-3.0f, 1.5f)
                curveTo(16.21f, 15.89f, 16.0f, 16.24f, 16.0f, 16.62f)
                verticalLineToRelative(1.93f)
                curveToRelative(0.0f, 2.52f, 1.71f, 4.88f, 4.0f, 5.45f)
                curveToRelative(2.29f, -0.57f, 4.0f, -2.93f, 4.0f, -5.45f)
                verticalLineToRelative(-1.93f)
                curveToRelative(0.0f, -0.38f, -0.21f, -0.73f, -0.55f, -0.89f)
                lineToRelative(-3.0f, -1.5f)
                curveTo(20.17f, 14.08f, 19.83f, 14.08f, 19.55f, 14.22f)
                close()
                moveTo(18.58f, 20.3f)
                lineToRelative(-0.8f, -0.8f)
                curveToRelative(-0.29f, -0.29f, -0.29f, -0.77f, 0.0f, -1.06f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.29f, -0.29f, 0.77f, -0.29f, 1.06f, 0.0f)
                lineToRelative(0.44f, 0.44f)
                lineToRelative(1.88f, -1.85f)
                curveToRelative(0.29f, -0.29f, 0.77f, -0.29f, 1.06f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.29f, 0.29f, 0.29f, 0.77f, 0.0f, 1.06f)
                lineToRelative(-2.23f, 2.21f)
                curveTo(19.6f, 20.69f, 18.97f, 20.69f, 18.58f, 20.3f)
                close()
            }
        }
        return _assuredWorkload!!
    }

private var _assuredWorkload: ImageVector? = null
