/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Unsubscribe: ImageVector
    get() {
        if (_unsubscribe != null) {
            return _unsubscribe!!
        }
        _unsubscribe = materialIcon(name = "Rounded.Unsubscribe") {
            materialPath {
                moveTo(18.5f, 11.5f)
                curveToRelative(0.92f, 0.0f, 1.75f, 0.26f, 2.49f, 0.69f)
                lineTo(20.99f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.89f, -2.0f, -1.99f, -2.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.55f)
                curveToRelative(-0.02f, -0.17f, -0.05f, -0.33f, -0.05f, -0.5f)
                curveToRelative(0.0f, -2.76f, 2.24f, -5.0f, 5.0f, -5.0f)
                close()
                moveTo(12.89f, 10.05f)
                curveToRelative(-0.56f, 0.28f, -1.23f, 0.28f, -1.79f, 0.0f)
                lineToRelative(-5.61f, -2.8f)
                curveToRelative(-0.3f, -0.15f, -0.49f, -0.46f, -0.49f, -0.8f)
                curveToRelative(0.0f, -0.66f, 0.7f, -1.1f, 1.29f, -0.8f)
                lineTo(12.0f, 8.5f)
                lineToRelative(5.71f, -2.85f)
                curveToRelative(0.59f, -0.3f, 1.29f, 0.13f, 1.29f, 0.8f)
                curveToRelative(0.0f, 0.34f, -0.19f, 0.65f, -0.49f, 0.8f)
                lineToRelative(-5.62f, 2.8f)
                close()
                moveTo(18.5f, 13.0f)
                curveToRelative(-1.93f, 0.0f, -3.5f, 1.57f, -3.5f, 3.5f)
                reflectiveCurveToRelative(1.57f, 3.5f, 3.5f, 3.5f)
                reflectiveCurveToRelative(3.5f, -1.57f, 3.5f, -3.5f)
                reflectiveCurveToRelative(-1.57f, -3.5f, -3.5f, -3.5f)
                close()
                moveTo(20.5f, 16.5f)
                curveToRelative(0.0f, 0.28f, -0.22f, 0.5f, -0.5f, 0.5f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                reflectiveCurveToRelative(0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                close()
            }
        }
        return _unsubscribe!!
    }

private var _unsubscribe: ImageVector? = null
