/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Volcano: ImageVector
    get() {
        if (_volcano != null) {
            return _volcano!!
        }
        _volcano = materialIcon(name = "TwoTone.Volcano") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.49f, 10.0f)
                lineToRelative(-4.14f, 0.0f)
                lineToRelative(-1.49f, 3.74f)
                lineToRelative(-0.51f, 1.26f)
                lineToRelative(-1.35f, 0.0f)
                lineToRelative(-1.7f, 0.0f)
                lineToRelative(-2.22f, 5.0f)
                lineToRelative(14.27f, 0.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 8.0f)
                horizontalLineToRelative(-7.0f)
                lineToRelative(-2.0f, 5.0f)
                horizontalLineTo(6.0f)
                lineToRelative(-4.0f, 9.0f)
                horizontalLineToRelative(20.0f)
                lineTo(18.0f, 8.0f)
                close()
                moveTo(7.3f, 15.0f)
                horizontalLineTo(9.0f)
                horizontalLineToRelative(1.35f)
                lineToRelative(0.5f, -1.26f)
                lineToRelative(1.5f, -3.74f)
                horizontalLineToRelative(4.14f)
                lineToRelative(2.86f, 10.0f)
                horizontalLineTo(5.08f)
                lineTo(7.3f, 15.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(16.121f, 5.468f)
                lineToRelative(2.828f, -2.828f)
                lineToRelative(1.414f, 1.414f)
                lineToRelative(-2.828f, 2.828f)
                close()
            }
            materialPath {
                moveTo(7.64f, 4.05f)
                lineToRelative(1.414f, -1.414f)
                lineToRelative(2.828f, 2.828f)
                lineToRelative(-1.414f, 1.414f)
                close()
            }
        }
        return _volcano!!
    }

private var _volcano: ImageVector? = null
