/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material.ripple;

import androidx.compose.animation.AnimatedFloatModel;
import androidx.compose.animation.core.AnimationClockObservable;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.BaseAnimatedValue;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.TweenSpec;
import androidx.compose.foundation.Interaction;
import androidx.compose.foundation.InteractionState;
import androidx.compose.material.ripple.ExperimentalRippleApi;
import androidx.compose.material.ripple.RippleAlpha;
import androidx.compose.material.ripple.RippleKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExperimentalRippleApi
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Landroidx/compose/material/ripple/StateLayer;", "", "clock", "Landroidx/compose/animation/core/AnimationClockObservable;", "bounded", "", "rippleAlpha", "Landroidx/compose/material/ripple/RippleAlpha;", "(Landroidx/compose/animation/core/AnimationClockObservable;ZLandroidx/compose/material/ripple/RippleAlpha;)V", "animatedAlpha", "Landroidx/compose/animation/AnimatedFloatModel;", "lastDrawnInteraction", "Landroidx/compose/foundation/Interaction;", "previousInteractions", "", "drawStateLayer", "", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "interactionState", "Landroidx/compose/foundation/InteractionState;", "targetRadius", "", "color", "Landroidx/compose/ui/graphics/Color;", "drawStateLayer-pqS-j0w", "(Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;Landroidx/compose/foundation/InteractionState;FJ)V", "material-ripple_release"})
final class StateLayer {
    private final boolean bounded;
    @NotNull
    private final RippleAlpha rippleAlpha;
    @NotNull
    private final AnimatedFloatModel animatedAlpha;
    @NotNull
    private Set<? extends Interaction> previousInteractions;
    @Nullable
    private Interaction lastDrawnInteraction;

    public StateLayer(@NotNull AnimationClockObservable clock, boolean bounded, @NotNull RippleAlpha rippleAlpha) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)rippleAlpha, (String)"rippleAlpha");
        this.bounded = bounded;
        this.rippleAlpha = rippleAlpha;
        this.animatedAlpha = new AnimatedFloatModel(0.0f, clock, 0.0f, 4, null);
        this.previousInteractions = SetsKt.emptySet();
    }

    public final void drawStateLayer-pqS-j0w(@NotNull ContentDrawScope $receiver, @NotNull InteractionState interactionState, float targetRadius, long color) {
        Interaction previousInteraction;
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        Intrinsics.checkNotNullParameter((Object)interactionState, (String)"interactionState");
        Set currentInteractions = interactionState.getValue();
        boolean handled = false;
        for (Interaction interaction : CollectionsKt.reversed((Iterable)currentInteractions)) {
            float targetAlpha;
            if (handled) break;
            if (interaction instanceof Interaction.Pressed || this.previousInteractions.contains(interaction) || (targetAlpha = this.rippleAlpha.alphaForInteraction(interaction)) == 0.0f) continue;
            AnimationSpec animationSpec = (AnimationSpec)RippleKt.access$getIncomingStateLayerAnimationSpecs$p$s-1106618407().get(interaction);
            AnimationSpec incomingAnimationSpec = animationSpec == null ? (AnimationSpec)new TweenSpec(15, 0, EasingKt.getLinearEasing(), 2, null) : animationSpec;
            BaseAnimatedValue.animateTo$default((BaseAnimatedValue)((BaseAnimatedValue)this.animatedAlpha), (Object)Float.valueOf(targetAlpha), (AnimationSpec)incomingAnimationSpec, null, (int)4, null);
            this.lastDrawnInteraction = interaction;
            handled = true;
        }
        if (!handled && (previousInteraction = this.lastDrawnInteraction) != null && !currentInteractions.contains(previousInteraction)) {
            AnimationSpec animationSpec = (AnimationSpec)RippleKt.access$getOutgoingStateLayerAnimationSpecs$p$s-1106618407().get(previousInteraction);
            AnimationSpec outgoingAnimationSpec = animationSpec == null ? (AnimationSpec)new TweenSpec(15, 0, EasingKt.getLinearEasing(), 2, null) : animationSpec;
            BaseAnimatedValue.animateTo$default((BaseAnimatedValue)((BaseAnimatedValue)this.animatedAlpha), (Object)Float.valueOf(0.0f), (AnimationSpec)outgoingAnimationSpec, null, (int)4, null);
            this.lastDrawnInteraction = null;
        }
        this.previousInteractions = currentInteractions;
        float alpha = this.animatedAlpha.getValue().floatValue();
        if (alpha > 0.0f) {
            long modulatedColor = Color.copy-0d7_KjU$default((long)color, (float)alpha, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
            if (this.bounded) {
                DrawScope $this$clipRect$iv = (DrawScope)$receiver;
                float left$iv = 0.0f;
                float top$iv = 0.0f;
                float right$iv = Size.getWidth-impl((long)$this$clipRect$iv.getSize-NH-jbRc());
                float bottom$iv = Size.getHeight-impl((long)$this$clipRect$iv.getSize-NH-jbRc());
                ClipOp clipOp$iv = ClipOp.Intersect;
                boolean $i$f$clipRect = false;
                DrawScope $this$withTransform$iv$iv = $this$clipRect$iv;
                boolean $i$f$withTransform = false;
                DrawContext drawContext = $this$withTransform$iv$iv.getDrawContext();
                boolean bl = false;
                boolean bl2 = false;
                DrawContext $this$with$iv$iv = drawContext;
                boolean bl3 = false;
                long previousSize$iv$iv = $this$with$iv$iv.getSize-NH-jbRc();
                $this$with$iv$iv.getCanvas().save();
                DrawTransform $this$withTransform$iv = $this$with$iv$iv.getTransform();
                boolean bl4 = false;
                $this$withTransform$iv.clipRect(left$iv, top$iv, right$iv, bottom$iv, clipOp$iv);
                DrawScope $this$drawStateLayer_pqS_j0w_u24lambda_u2d0 = $this$withTransform$iv$iv;
                boolean bl5 = false;
                DrawScope.DefaultImpls.drawCircle-NGaRamM$default((DrawScope)$this$drawStateLayer_pqS_j0w_u24lambda_u2d0, (long)modulatedColor, (float)targetRadius, (long)0L, (float)0.0f, null, null, null, (int)124, null);
                $this$with$iv$iv.getCanvas().restore();
                $this$with$iv$iv.setSize-uvyYCjk(previousSize$iv$iv);
            } else {
                DrawScope.DefaultImpls.drawCircle-NGaRamM$default((DrawScope)((DrawScope)$receiver), (long)modulatedColor, (float)targetRadius, (long)0L, (float)0.0f, null, null, null, (int)124, null);
            }
        }
    }
}

