/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.annotation.RequiresApi;
import androidx.compose.material3.CalendarDate;
import androidx.compose.material3.CalendarModel;
import androidx.compose.material3.CalendarModelKt;
import androidx.compose.material3.CalendarMonth;
import androidx.compose.material3.DateInputFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.DecimalStyle;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0001\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0004H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0004H\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\f\u0010*\u001a\u00020 *\u00020\bH\u0002J\f\u0010*\u001a\u00020 *\u00020\u001eH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Landroidx/compose/material3/CalendarModelImpl;", "Landroidx/compose/material3/CalendarModel;", "()V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "today", "Landroidx/compose/material3/CalendarDate;", "getToday", "()Landroidx/compose/material3/CalendarDate;", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "formatWithPattern", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "getCanonicalDate", "timeInMillis", "getDateInputFormat", "Landroidx/compose/material3/DateInputFormat;", "getDayOfWeek", "date", "getMonth", "Landroidx/compose/material3/CalendarMonth;", "firstDayLocalDate", "Ljava/time/LocalDate;", "year", "month", "minusMonths", "from", "subtractedMonthsCount", "parse", "plusMonths", "addedMonthsCount", "toString", "toLocalDate", "Companion", "material3_release"})
@RequiresApi(value=26)
@SourceDebugExtension(value={"SMAP\nCalendarModelImpl.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendarModelImpl.android.kt\nandroidx/compose/material3/CalendarModelImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,213:1\n11335#2:214\n11670#2,3:215\n*S KotlinDebug\n*F\n+ 1 CalendarModelImpl.android.kt\nandroidx/compose/material3/CalendarModelImpl\n*L\n61#1:214\n61#1:215,3\n*E\n"})
public final class CalendarModelImpl
implements CalendarModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int firstDayOfWeek = WeekFields.of(Locale.getDefault()).getFirstDayOfWeek().getValue();
    @NotNull
    private final List<Pair<String, String>> weekdayNames;
    @NotNull
    private static final ZoneId utcTimeZoneId;

    /*
     * WARNING - void declaration
     */
    public CalendarModelImpl() {
        void $this$mapTo$iv$iv;
        Locale locale = Locale.getDefault();
        CalendarModelImpl calendarModelImpl = this;
        boolean bl = false;
        DayOfWeek[] $this$map$iv = DayOfWeek.values();
        boolean $i$f$map = false;
        DayOfWeek[] dayOfWeekArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void $this$weekdayNames_u24lambda_u241;
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to((Object)it.getDisplayName(TextStyle.FULL, (Locale)$this$weekdayNames_u24lambda_u241), (Object)it.getDisplayName(TextStyle.NARROW, (Locale)$this$weekdayNames_u24lambda_u241)));
        }
        calendarModelImpl.weekdayNames = (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public CalendarDate getToday() {
        LocalDate systemLocalDate = LocalDate.now();
        return new CalendarDate(systemLocalDate.getYear(), systemLocalDate.getMonthValue(), systemLocalDate.getDayOfMonth(), systemLocalDate.atTime(LocalTime.MIDNIGHT).atZone(utcTimeZoneId).toInstant().toEpochMilli());
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getWeekdayNames() {
        return this.weekdayNames;
    }

    @Override
    @NotNull
    public DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string2 = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, null, Chronology.ofLocale(locale), locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalizedDateTimePatt\u2026= */ locale\n            )");
        return CalendarModelKt.datePatternAsInputFormat(string2);
    }

    @Override
    @NotNull
    public CalendarDate getCanonicalDate(long timeInMillis) {
        LocalDate localDate = Instant.ofEpochMilli(timeInMillis).atZone(utcTimeZoneId).toLocalDate();
        return new CalendarDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), localDate.atStartOfDay().toEpochSecond(ZoneOffset.UTC) * (long)1000);
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(long timeInMillis) {
        LocalDate localDate = Instant.ofEpochMilli(timeInMillis).atZone(utcTimeZoneId).withDayOfMonth(1).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochMilli(timeInMilli\u2026           .toLocalDate()");
        return this.getMonth(localDate);
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        LocalDate localDate = LocalDate.of(date.getYear(), date.getMonth(), 1);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(date.year, date.month, 1)");
        return this.getMonth(localDate);
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(int year, int month) {
        LocalDate localDate = LocalDate.of(year, month, 1);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(year, month, 1)");
        return this.getMonth(localDate);
    }

    @Override
    public int getDayOfWeek(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.toLocalDate(date).getDayOfWeek().getValue();
    }

    @Override
    @NotNull
    public CalendarMonth plusMonths(@NotNull CalendarMonth from, int addedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (addedMonthsCount <= 0) {
            return from;
        }
        LocalDate firstDayLocalDate = this.toLocalDate(from);
        LocalDate laterMonth = firstDayLocalDate.plusMonths(addedMonthsCount);
        Intrinsics.checkNotNullExpressionValue((Object)laterMonth, (String)"laterMonth");
        return this.getMonth(laterMonth);
    }

    @Override
    @NotNull
    public CalendarMonth minusMonths(@NotNull CalendarMonth from, int subtractedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (subtractedMonthsCount <= 0) {
            return from;
        }
        LocalDate firstDayLocalDate = this.toLocalDate(from);
        LocalDate earlierMonth = firstDayLocalDate.minusMonths(subtractedMonthsCount);
        Intrinsics.checkNotNullExpressionValue((Object)earlierMonth, (String)"earlierMonth");
        return this.getMonth(earlierMonth);
    }

    @Override
    @NotNull
    public String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return Companion.formatWithPattern(utcTimeMillis, pattern, locale);
    }

    @Override
    @Nullable
    public CalendarDate parse(@NotNull String date, @NotNull String pattern) {
        CalendarDate calendarDate;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        try {
            LocalDate localDate = LocalDate.parse(date, formatter);
            calendarDate = new CalendarDate(localDate.getYear(), localDate.getMonth().getValue(), localDate.getDayOfMonth(), localDate.atTime(LocalTime.MIDNIGHT).atZone(utcTimeZoneId).toInstant().toEpochMilli());
        }
        catch (DateTimeParseException pe) {
            calendarDate = null;
        }
        return calendarDate;
    }

    @NotNull
    public String toString() {
        return "CalendarModel";
    }

    private final CalendarMonth getMonth(LocalDate firstDayLocalDate) {
        int difference = firstDayLocalDate.getDayOfWeek().getValue() - this.getFirstDayOfWeek();
        int daysFromStartOfWeekToFirstOfMonth = difference < 0 ? difference + 7 : difference;
        long firstDayEpochMillis = firstDayLocalDate.atTime(LocalTime.MIDNIGHT).atZone(utcTimeZoneId).toInstant().toEpochMilli();
        return new CalendarMonth(firstDayLocalDate.getYear(), firstDayLocalDate.getMonthValue(), firstDayLocalDate.lengthOfMonth(), daysFromStartOfWeekToFirstOfMonth, firstDayEpochMillis);
    }

    private final LocalDate toLocalDate(CalendarMonth $this$toLocalDate) {
        LocalDate localDate = Instant.ofEpochMilli($this$toLocalDate.getStartUtcTimeMillis()).atZone(utcTimeZoneId).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochMilli(startUtcTim\u2026TimeZoneId).toLocalDate()");
        return localDate;
    }

    private final LocalDate toLocalDate(CalendarDate $this$toLocalDate) {
        LocalDate localDate = LocalDate.of($this$toLocalDate.getYear(), $this$toLocalDate.getMonth(), $this$toLocalDate.getDayOfMonth());
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(\n            this.yea\u2026this.dayOfMonth\n        )");
        return localDate;
    }

    static {
        ZoneId zoneId = ZoneId.of("UTC");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(\"UTC\")");
        utcTimeZoneId = zoneId;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Landroidx/compose/material3/CalendarModelImpl$Companion;", "", "()V", "utcTimeZoneId", "Ljava/time/ZoneId;", "getUtcTimeZoneId$material3_release", "()Ljava/time/ZoneId;", "formatWithPattern", "", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "material3_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern, locale).withDecimalStyle(DecimalStyle.of(locale));
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(pattern, local\u2026(DecimalStyle.of(locale))");
            DateTimeFormatter formatter = dateTimeFormatter;
            String string2 = Instant.ofEpochMilli(utcTimeMillis).atZone(this.getUtcTimeZoneId$material3_release()).toLocalDate().format(formatter);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ofEpochMilli(utcTimeMill\u2026       .format(formatter)");
            return string2;
        }

        @NotNull
        public final ZoneId getUtcTimeZoneId$material3_release() {
            return utcTimeZoneId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

