/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import android.content.res.Configuration;
import android.os.Build;
import android.text.format.DateFormat;
import androidx.compose.material3.CalendarModel;
import androidx.compose.material3.CalendarModelImpl;
import androidx.compose.material3.ExperimentalMaterial3Api;
import androidx.compose.material3.LegacyCalendarModelImpl;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.ReadOnlyComposable;
import androidx.compose.ui.platform.AndroidCompositionLocals_androidKt;
import androidx.core.os.ConfigurationCompat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0001\u001a\r\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0003H\u0001\u00a8\u0006\u000b"}, d2={"CalendarModel", "Landroidx/compose/material3/CalendarModel;", "defaultLocale", "Ljava/util/Locale;", "(Landroidx/compose/runtime/Composer;I)Ljava/util/Locale;", "formatWithSkeleton", "", "utcTimeMillis", "", "skeleton", "locale", "material3_release"})
@SourceDebugExtension(value={"SMAP\nCalendarModel.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendarModel.android.kt\nandroidx/compose/material3/CalendarModel_androidKt\n+ 2 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n*L\n1#1,76:1\n76#2:77\n*S KotlinDebug\n*F\n+ 1 CalendarModel.android.kt\nandroidx/compose/material3/CalendarModel_androidKt\n*L\n74#1:77\n*E\n"})
public final class CalendarModel_androidKt {
    @ExperimentalMaterial3Api
    @NotNull
    public static final CalendarModel CalendarModel() {
        return Build.VERSION.SDK_INT >= 26 ? (CalendarModel)new CalendarModelImpl() : (CalendarModel)new LegacyCalendarModelImpl();
    }

    @ExperimentalMaterial3Api
    @NotNull
    public static final String formatWithSkeleton(long utcTimeMillis, @NotNull String skeleton, @NotNull Locale locale) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)skeleton, (String)"skeleton");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String pattern = DateFormat.getBestDateTimePattern((Locale)locale, (String)skeleton);
        if (Build.VERSION.SDK_INT >= 26) {
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"pattern");
            string2 = CalendarModelImpl.Companion.formatWithPattern(utcTimeMillis, pattern, locale);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"pattern");
            string2 = LegacyCalendarModelImpl.Companion.formatWithPattern(utcTimeMillis, pattern, locale);
        }
        return string2;
    }

    public static /* synthetic */ String formatWithSkeleton$default(long l, String string2, Locale locale, int n, Object object) {
        if ((n & 4) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"m epoch)\n * ");
            locale = locale2;
        }
        return CalendarModel_androidKt.formatWithSkeleton(l, string2, locale);
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @ReadOnlyComposable
    @ExperimentalMaterial3Api
    @NotNull
    public static final Locale defaultLocale(@Nullable Composer $composer, int $changed) {
        void this_$iv;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)895332416, (String)"C(defaultLocale)73@2608L7:CalendarModel.android.kt#uh7d8r");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)895332416, (int)$changed, (int)-1, (String)"androidx.compose.material3.defaultLocale (CalendarModel.android.kt:72)");
        }
        CompositionLocal compositionLocal = (CompositionLocal)AndroidCompositionLocals_androidKt.getLocalConfiguration();
        boolean $changed$iv = false;
        boolean $i$f$getCurrent = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC:CompositionLocal.kt#9igjgp");
        Object object = $composer.consume((CompositionLocal)this_$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        Locale locale = ConfigurationCompat.getLocales((Configuration)((Configuration)object)).get(0);
        if (locale == null) {
            Locale locale2 = Locale.getDefault();
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
        }
        Locale locale3 = locale;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return locale3;
    }
}

