/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.CalendarModel;
import androidx.compose.material3.ExperimentalMaterial3Api;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\b\b\u0002\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006("}, d2={"Landroidx/compose/material3/CalendarMonth;", "", "year", "", "month", "numberOfDays", "daysFromStartOfWeekToFirstOfMonth", "startUtcTimeMillis", "", "(IIIIJ)V", "getDaysFromStartOfWeekToFirstOfMonth", "()I", "endUtcTimeMillis", "getEndUtcTimeMillis", "()J", "getMonth", "getNumberOfDays", "getStartUtcTimeMillis", "getYear", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "format", "", "calendarModel", "Landroidx/compose/material3/CalendarModel;", "skeleton", "locale", "Ljava/util/Locale;", "hashCode", "indexIn", "years", "Lkotlin/ranges/IntRange;", "toString", "material3_release"})
@ExperimentalMaterial3Api
public final class CalendarMonth {
    private final int year;
    private final int month;
    private final int numberOfDays;
    private final int daysFromStartOfWeekToFirstOfMonth;
    private final long startUtcTimeMillis;
    private final long endUtcTimeMillis;

    public CalendarMonth(int year, int month, int numberOfDays, int daysFromStartOfWeekToFirstOfMonth, long startUtcTimeMillis) {
        this.year = year;
        this.month = month;
        this.numberOfDays = numberOfDays;
        this.daysFromStartOfWeekToFirstOfMonth = daysFromStartOfWeekToFirstOfMonth;
        this.startUtcTimeMillis = startUtcTimeMillis;
        this.endUtcTimeMillis = this.startUtcTimeMillis + (long)this.numberOfDays * 86400000L - 1L;
    }

    public final int getYear() {
        return this.year;
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getNumberOfDays() {
        return this.numberOfDays;
    }

    public final int getDaysFromStartOfWeekToFirstOfMonth() {
        return this.daysFromStartOfWeekToFirstOfMonth;
    }

    public final long getStartUtcTimeMillis() {
        return this.startUtcTimeMillis;
    }

    public final long getEndUtcTimeMillis() {
        return this.endUtcTimeMillis;
    }

    public final int indexIn(@NotNull IntRange years) {
        Intrinsics.checkNotNullParameter((Object)years, (String)"years");
        return (this.year - years.getFirst()) * 12 + this.month - 1;
    }

    @NotNull
    public final String format(@NotNull CalendarModel calendarModel, @NotNull String skeleton, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)calendarModel, (String)"calendarModel");
        Intrinsics.checkNotNullParameter((Object)skeleton, (String)"skeleton");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return calendarModel.formatWithSkeleton(this, skeleton, locale);
    }

    public static /* synthetic */ String format$default(CalendarMonth calendarMonth, CalendarModel calendarModel, String string2, Locale locale, int n, Object object) {
        if ((n & 4) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return calendarMonth.format(calendarModel, string2, locale);
    }

    public final int component1() {
        return this.year;
    }

    public final int component2() {
        return this.month;
    }

    public final int component3() {
        return this.numberOfDays;
    }

    public final int component4() {
        return this.daysFromStartOfWeekToFirstOfMonth;
    }

    public final long component5() {
        return this.startUtcTimeMillis;
    }

    @NotNull
    public final CalendarMonth copy(int year, int month, int numberOfDays, int daysFromStartOfWeekToFirstOfMonth, long startUtcTimeMillis) {
        return new CalendarMonth(year, month, numberOfDays, daysFromStartOfWeekToFirstOfMonth, startUtcTimeMillis);
    }

    public static /* synthetic */ CalendarMonth copy$default(CalendarMonth calendarMonth, int n, int n2, int n3, int n4, long l, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = calendarMonth.year;
        }
        if ((n5 & 2) != 0) {
            n2 = calendarMonth.month;
        }
        if ((n5 & 4) != 0) {
            n3 = calendarMonth.numberOfDays;
        }
        if ((n5 & 8) != 0) {
            n4 = calendarMonth.daysFromStartOfWeekToFirstOfMonth;
        }
        if ((n5 & 0x10) != 0) {
            l = calendarMonth.startUtcTimeMillis;
        }
        return calendarMonth.copy(n, n2, n3, n4, l);
    }

    @NotNull
    public String toString() {
        return "CalendarMonth(year=" + this.year + ", month=" + this.month + ", numberOfDays=" + this.numberOfDays + ", daysFromStartOfWeekToFirstOfMonth=" + this.daysFromStartOfWeekToFirstOfMonth + ", startUtcTimeMillis=" + this.startUtcTimeMillis + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.year);
        result2 = result2 * 31 + Integer.hashCode(this.month);
        result2 = result2 * 31 + Integer.hashCode(this.numberOfDays);
        result2 = result2 * 31 + Integer.hashCode(this.daysFromStartOfWeekToFirstOfMonth);
        result2 = result2 * 31 + Long.hashCode(this.startUtcTimeMillis);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CalendarMonth)) {
            return false;
        }
        CalendarMonth calendarMonth = (CalendarMonth)other;
        if (this.year != calendarMonth.year) {
            return false;
        }
        if (this.month != calendarMonth.month) {
            return false;
        }
        if (this.numberOfDays != calendarMonth.numberOfDays) {
            return false;
        }
        if (this.daysFromStartOfWeekToFirstOfMonth != calendarMonth.daysFromStartOfWeekToFirstOfMonth) {
            return false;
        }
        return this.startUtcTimeMillis == calendarMonth.startUtcTimeMillis;
    }
}

