/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.material3.ExperimentalMaterial3Api;
import androidx.compose.material3.SheetState;
import androidx.compose.material3.SheetValue;
import androidx.compose.material3.SwipeableV2Defaults;
import androidx.compose.material3.SwipeableV2State;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ%\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010#\u001a\u00020\u0014H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%J\u0011\u0010&\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0011\u0010(\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0011\u0010)\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0006\u0010*\u001a\u00020\u0014J\u001b\u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b,\u0010-J\u0011\u0010.\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u001b\u0010/\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u0005H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00063"}, d2={"Landroidx/compose/material3/SheetState;", "", "skipPartiallyExpanded", "", "initialValue", "Landroidx/compose/material3/SheetValue;", "confirmValueChange", "Lkotlin/Function1;", "skipHiddenState", "(ZLandroidx/compose/material3/SheetValue;Lkotlin/jvm/functions/Function1;Z)V", "currentValue", "getCurrentValue", "()Landroidx/compose/material3/SheetValue;", "hasExpandedState", "getHasExpandedState", "()Z", "hasPartiallyExpandedState", "getHasPartiallyExpandedState", "isVisible", "offset", "", "getOffset$material3_release", "()Ljava/lang/Float;", "getSkipHiddenState$material3_release", "getSkipPartiallyExpanded$material3_release", "swipeableState", "Landroidx/compose/material3/SwipeableV2State;", "getSwipeableState$material3_release", "()Landroidx/compose/material3/SwipeableV2State;", "setSwipeableState$material3_release", "(Landroidx/compose/material3/SwipeableV2State;)V", "targetValue", "getTargetValue", "animateTo", "", "velocity", "animateTo$material3_release", "(Landroidx/compose/material3/SheetValue;FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "expand", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hide", "partialExpand", "requireOffset", "settle", "settle$material3_release", "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "show", "snapTo", "snapTo$material3_release", "(Landroidx/compose/material3/SheetValue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "material3_release"})
@Stable
@ExperimentalMaterial3Api
public final class SheetState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean skipPartiallyExpanded;
    private final boolean skipHiddenState;
    @NotNull
    private SwipeableV2State<SheetValue> swipeableState;
    public static final int $stable;

    public SheetState(boolean skipPartiallyExpanded, @NotNull SheetValue initialValue, @NotNull Function1<? super SheetValue, Boolean> confirmValueChange, boolean skipHiddenState) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialValue), (String)"initialValue");
        Intrinsics.checkNotNullParameter(confirmValueChange, (String)"confirmValueChange");
        this.skipPartiallyExpanded = skipPartiallyExpanded;
        this.skipHiddenState = skipHiddenState;
        if (this.skipPartiallyExpanded && !(initialValue != SheetValue.PartiallyExpanded)) {
            boolean $i$a$-require-SheetState$42 = false;
            String $i$a$-require-SheetState$42 = "The initial value must not be set to PartiallyExpanded if skipPartiallyExpanded is set to true.";
            throw new IllegalArgumentException($i$a$-require-SheetState$42.toString());
        }
        if (this.skipHiddenState && !(initialValue != SheetValue.Hidden)) {
            boolean bl = false;
            String string2 = "The initial value must not be set to Hidden if skipHiddenState is set to true.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.swipeableState = new SwipeableV2State((Object)initialValue, (AnimationSpec)SwipeableV2Defaults.INSTANCE.getAnimationSpec(), confirmValueChange, null, 0.0f, 24, null);
    }

    public /* synthetic */ SheetState(boolean bl, SheetValue sheetValue, Function1 function1, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            sheetValue = SheetValue.Hidden;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(bl, sheetValue, (Function1<? super SheetValue, Boolean>)function1, bl2);
    }

    public final boolean getSkipPartiallyExpanded$material3_release() {
        return this.skipPartiallyExpanded;
    }

    public final boolean getSkipHiddenState$material3_release() {
        return this.skipHiddenState;
    }

    @NotNull
    public final SheetValue getCurrentValue() {
        return this.swipeableState.getCurrentValue();
    }

    @NotNull
    public final SheetValue getTargetValue() {
        return this.swipeableState.getTargetValue();
    }

    public final boolean isVisible() {
        return this.swipeableState.getCurrentValue() != SheetValue.Hidden;
    }

    public final float requireOffset() {
        return this.swipeableState.requireOffset();
    }

    public final boolean getHasExpandedState() {
        return this.swipeableState.hasAnchorForValue(SheetValue.Expanded);
    }

    public final boolean getHasPartiallyExpandedState() {
        return this.swipeableState.hasAnchorForValue(SheetValue.PartiallyExpanded);
    }

    @Nullable
    public final Object expand(@NotNull Continuation<? super Unit> $completion) {
        Object object = SwipeableV2State.animateTo$default(this.swipeableState, (Object)SheetValue.Expanded, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object partialExpand(@NotNull Continuation<? super Unit> $completion) {
        if (!(!this.skipPartiallyExpanded)) {
            boolean bl = false;
            String string2 = "Attempted to animate to partial expanded when skipPartiallyExpanded was enabled. Set skipPartiallyExpanded to false to use this function.";
            throw new IllegalStateException(string2.toString());
        }
        Object object = SheetState.animateTo$material3_release$default(this, SheetValue.PartiallyExpanded, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object show(@NotNull Continuation<? super Unit> $completion) {
        SheetValue targetValue2 = this.getHasPartiallyExpandedState() ? SheetValue.PartiallyExpanded : SheetValue.Expanded;
        Object object = SheetState.animateTo$material3_release$default(this, targetValue2, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object hide(@NotNull Continuation<? super Unit> $completion) {
        if (!(!this.skipHiddenState)) {
            boolean bl = false;
            String string2 = "Attempted to animate to hidden when skipHiddenState was enabled. Set skipHiddenState to false to use this function.";
            throw new IllegalStateException(string2.toString());
        }
        Object object = SheetState.animateTo$material3_release$default(this, SheetValue.Hidden, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object animateTo$material3_release(@NotNull SheetValue targetValue2, float velocity, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.swipeableState.animateTo(targetValue2, velocity, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object animateTo$material3_release$default(SheetState sheetState, SheetValue sheetValue, float f, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            f = sheetState.swipeableState.getLastVelocity();
        }
        return sheetState.animateTo$material3_release(sheetValue, f, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object snapTo$material3_release(@NotNull SheetValue targetValue2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.swipeableState.snapTo(targetValue2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object settle$material3_release(float velocity, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.swipeableState.settle(velocity, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final SwipeableV2State<SheetValue> getSwipeableState$material3_release() {
        return this.swipeableState;
    }

    public final void setSwipeableState$material3_release(@NotNull SwipeableV2State<SheetValue> swipeableV2State) {
        Intrinsics.checkNotNullParameter(swipeableV2State, (String)"<set-?>");
        this.swipeableState = swipeableV2State;
    }

    @Nullable
    public final Float getOffset$material3_release() {
        return this.swipeableState.getOffset();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\n\u00a8\u0006\u000b"}, d2={"Landroidx/compose/material3/SheetState$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/material3/SheetState;", "Landroidx/compose/material3/SheetValue;", "skipPartiallyExpanded", "", "confirmValueChange", "Lkotlin/Function1;", "material3_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<SheetState, SheetValue> Saver(boolean skipPartiallyExpanded, @NotNull Function1<? super SheetValue, Boolean> confirmValueChange) {
            Intrinsics.checkNotNullParameter(confirmValueChange, (String)"confirmValueChange");
            return SaverKt.Saver((Function2)Saver.1.INSTANCE, (Function1)((Function1)new Function1<SheetValue, SheetState>(skipPartiallyExpanded, confirmValueChange){
                final /* synthetic */ boolean $skipPartiallyExpanded;
                final /* synthetic */ Function1<SheetValue, Boolean> $confirmValueChange;
                {
                    this.$skipPartiallyExpanded = $skipPartiallyExpanded;
                    this.$confirmValueChange = $confirmValueChange;
                    super(1);
                }

                @Nullable
                public final SheetState invoke(@NotNull SheetValue savedValue) {
                    Intrinsics.checkNotNullParameter((Object)((Object)savedValue), (String)"savedValue");
                    return new SheetState(this.$skipPartiallyExpanded, savedValue, this.$confirmValueChange, false, 8, null);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

