/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.lint;

import androidx.compose.material3.lint.MaterialImportDetectorKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UImportStatement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/material3/lint/MaterialImportDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UImportStatement;", "Companion", "material3-lint"})
public final class MaterialImportDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UsingMaterialAndMaterial3Libraries = Issue.Companion.create("UsingMaterialAndMaterial3Libraries", "material and material3 are separate, incompatible design system libraries", "material and material3 are separate design system libraries that are incompatible with each other, as they have their own distinct theming systems. Using components from both libraries concurrently can cause issues: for example material components will not pick up the correct content color from a material3 container, and vice versa.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(MaterialImportDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UImportStatement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UImportStatement.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitImportStatement(@NotNull UImportStatement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement uElement = node.getImportReference();
                if (uElement == null) {
                    return;
                }
                UElement reference = uElement;
                String importString = reference.asSourceString();
                if (Intrinsics.areEqual((Object)importString, (Object)"androidx.compose.material") || StringsKt.contains$default((CharSequence)importString, (CharSequence)"androidx.compose.material.", (boolean)false, (int)2, null)) {
                    boolean bl;
                    block11: {
                        String it;
                        boolean bl2;
                        boolean $i$f$any;
                        Iterable $this$any$iv;
                        block10: {
                            $this$any$iv = MaterialImportDetectorKt.access$getAllowlistedSubpackages$p();
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    boolean bl3 = false;
                                    if (!StringsKt.contains$default((CharSequence)importString, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                    bl2 = true;
                                    break block10;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            return;
                        }
                        $this$any$iv = MaterialImportDetectorKt.access$getAllowlistedImports$p();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)importString, (Object)it)) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return;
                    }
                    JavaContext.report$default((JavaContext)this.$context, (Issue)MaterialImportDetector.Companion.getUsingMaterialAndMaterial3Libraries(), (UElement)reference, (Location)this.$context.getLocation(reference), (String)"Using a material import while also using the material3 library", null, (int)16, null);
                }
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/material3/lint/MaterialImportDetector$Companion;", "", "()V", "UsingMaterialAndMaterial3Libraries", "Lcom/android/tools/lint/detector/api/Issue;", "getUsingMaterialAndMaterial3Libraries", "()Lcom/android/tools/lint/detector/api/Issue;", "material3-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUsingMaterialAndMaterial3Libraries() {
            return UsingMaterialAndMaterial3Libraries;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

