/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0003R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001a"}, d2={"Landroidx/compose/material3/carousel/Arrangement;", "", "priority", "", "smallSize", "", "smallCount", "mediumSize", "mediumCount", "largeSize", "largeCount", "(IFIFIFI)V", "getLargeCount", "()I", "getLargeSize", "()F", "getMediumCount", "getMediumSize", "getSmallCount", "getSmallSize", "cost", "targetLargeSize", "isValid", "", "itemCount", "Companion", "material3_release"})
@StabilityInferred(parameters=1)
public final class Arrangement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int priority;
    private final float smallSize;
    private final int smallCount;
    private final float mediumSize;
    private final int mediumCount;
    private final float largeSize;
    private final int largeCount;
    public static final int $stable;
    private static final float MediumItemFlexPercentage = 0.1f;

    public Arrangement(int priority, float smallSize, int smallCount, float mediumSize, int mediumCount, float largeSize, int largeCount) {
        this.priority = priority;
        this.smallSize = smallSize;
        this.smallCount = smallCount;
        this.mediumSize = mediumSize;
        this.mediumCount = mediumCount;
        this.largeSize = largeSize;
        this.largeCount = largeCount;
    }

    public final float getSmallSize() {
        return this.smallSize;
    }

    public final int getSmallCount() {
        return this.smallCount;
    }

    public final float getMediumSize() {
        return this.mediumSize;
    }

    public final int getMediumCount() {
        return this.mediumCount;
    }

    public final float getLargeSize() {
        return this.largeSize;
    }

    public final int getLargeCount() {
        return this.largeCount;
    }

    private final boolean isValid() {
        if (this.largeCount > 0 && this.smallCount > 0 && this.mediumCount > 0) {
            return this.largeSize > this.mediumSize && this.mediumSize > this.smallSize;
        }
        if (this.largeCount > 0 && this.smallCount > 0) {
            return this.largeSize > this.smallSize;
        }
        return true;
    }

    private final float cost(float targetLargeSize) {
        if (!this.isValid()) {
            return Float.MAX_VALUE;
        }
        return Math.abs(targetLargeSize - this.largeSize) * (float)this.priority;
    }

    public final int itemCount() {
        return this.largeCount + this.mediumCount + this.smallCount;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002JX\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0013J`\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/compose/material3/carousel/Arrangement$Companion;", "", "()V", "MediumItemFlexPercentage", "", "calculateLargeSize", "availableSpace", "smallCount", "", "smallSize", "mediumCount", "largeCount", "findLowestCostArrangement", "Landroidx/compose/material3/carousel/Arrangement;", "itemSpacing", "targetSmallSize", "minSmallSize", "maxSmallSize", "smallCounts", "", "targetMediumSize", "mediumCounts", "targetLargeSize", "largeCounts", "fit", "priority", "mediumSize", "largeSize", "material3_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Arrangement findLowestCostArrangement(float availableSpace, float itemSpacing, float targetSmallSize, float minSmallSize, float maxSmallSize, @NotNull int[] smallCounts, float targetMediumSize, @NotNull int[] mediumCounts, float targetLargeSize, @NotNull int[] largeCounts) {
            Arrangement lowestCostArrangement = null;
            int priority = 1;
            for (int largeCount : largeCounts) {
                for (int mediumCount : mediumCounts) {
                    for (int smallCount : smallCounts) {
                        Arrangement arrangement = this.fit(priority, availableSpace, itemSpacing, smallCount, targetSmallSize, minSmallSize, maxSmallSize, mediumCount, targetMediumSize, largeCount, targetLargeSize);
                        if ((lowestCostArrangement == null || arrangement.cost(targetLargeSize) < lowestCostArrangement.cost(targetLargeSize)) && (lowestCostArrangement = arrangement).cost(targetLargeSize) == 0.0f) {
                            return lowestCostArrangement;
                        }
                        ++priority;
                    }
                }
            }
            return lowestCostArrangement;
        }

        private final Arrangement fit(int priority, float availableSpace, float itemSpacing, int smallCount, float smallSize, float minSmallSize, float maxSmallSize, int mediumCount, float mediumSize, int largeCount, float largeSize) {
            int totalItemCount = largeCount + mediumCount + smallCount;
            float availableSpaceWithoutSpacing = availableSpace - (float)(totalItemCount - 1) * itemSpacing;
            float arrangedSmallSize = RangesKt.coerceIn((float)smallSize, (float)minSmallSize, (float)maxSmallSize);
            float arrangedMediumSize = mediumSize;
            float arrangedLargeSize = largeSize;
            float totalSpaceTakenByArrangement = arrangedLargeSize * (float)largeCount + arrangedMediumSize * (float)mediumCount + arrangedSmallSize * (float)smallCount;
            float delta = availableSpaceWithoutSpacing - totalSpaceTakenByArrangement;
            if (smallCount > 0 && delta > 0.0f) {
                arrangedSmallSize += Math.min(delta / (float)smallCount, maxSmallSize - arrangedSmallSize);
            } else if (smallCount > 0 && delta < 0.0f) {
                arrangedSmallSize += Math.max(delta / (float)smallCount, minSmallSize - arrangedSmallSize);
            }
            arrangedSmallSize = smallCount > 0 ? arrangedSmallSize : 0.0f;
            arrangedLargeSize = this.calculateLargeSize(availableSpaceWithoutSpacing, smallCount, arrangedSmallSize, mediumCount, largeCount);
            arrangedMediumSize = (arrangedLargeSize + arrangedSmallSize) / 2.0f;
            if (mediumCount > 0 && !(arrangedLargeSize == largeSize)) {
                float targetAdjustment = (largeSize - arrangedLargeSize) * (float)largeCount;
                float availableMediumFlex = arrangedMediumSize * 0.1f * (float)mediumCount;
                float distribute = Math.min(Math.abs(targetAdjustment), availableMediumFlex);
                if (targetAdjustment > 0.0f) {
                    arrangedMediumSize -= distribute / (float)mediumCount;
                    arrangedLargeSize += distribute / (float)largeCount;
                } else {
                    arrangedMediumSize += distribute / (float)mediumCount;
                    arrangedLargeSize -= distribute / (float)largeCount;
                }
            }
            return new Arrangement(priority, arrangedSmallSize, smallCount, arrangedMediumSize, mediumCount, arrangedLargeSize, largeCount);
        }

        private final float calculateLargeSize(float availableSpace, int smallCount, float smallSize, int mediumCount, int largeCount) {
            return (availableSpace - ((float)smallCount + (float)mediumCount / 2.0f) * smallSize) / ((float)largeCount + (float)mediumCount / 2.0f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

