/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.lint;

import androidx.compose.lint.KotlinUtilsKt;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.lint.UnreferencedParameter;
import androidx.compose.material3.lint.Material3Names;
import androidx.compose.material3.lint.ScaffoldPaddingDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/material3/lint/ScaffoldPaddingDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "material3-lint"})
@SourceDebugExtension(value={"SMAP\nScaffoldPaddingDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaffoldPaddingDetector.kt\nandroidx/compose/material3/lint/ScaffoldPaddingDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n515#2:93\n500#2,6:94\n800#3,11:100\n1855#3:111\n1856#3:113\n1#4:112\n*S KotlinDebug\n*F\n+ 1 ScaffoldPaddingDetector.kt\nandroidx/compose/material3/lint/ScaffoldPaddingDetector\n*L\n51#1:93\n51#1:94,6\n53#1:100,11\n56#1:111\n56#1:113\n*E\n"})
public final class ScaffoldPaddingDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UnusedMaterial3ScaffoldPaddingParameter = Issue.Companion.create("UnusedMaterial3ScaffoldPaddingParameter", "Scaffold content should use the padding provided as a lambda parameter", "The `content` lambda in Scaffold has a padding parameter which will include any inner padding for the content due to app bars. If this parameter is ignored, then content may be obscured by the app bars resulting in visual issues or elements that can't be interacted with.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ScaffoldPaddingDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)ScaffoldPaddingDetectorKt.access$getScaffold$p().getShortName());
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block8: {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (!PsiUtilsKt.isInPackageName(method, Material3Names.Material3.INSTANCE.getPackageName())) break block8;
            Map map = Lint.computeKotlinArgumentMapping((UCallExpression)node, (PsiMethod)method);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map map2 = map;
            boolean $i$f$filter = false;
            void var8_8 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                PsiParameter parameter = (PsiParameter)entry.getValue();
                if (!Intrinsics.areEqual((Object)parameter.getName(), (Object)"content")) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv.keySet();
            boolean $i$f$filterIsInstance = false;
            $this$filterTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Map.Entry element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ULambdaExpression)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ULambdaExpression uLambdaExpression = (ULambdaExpression)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (uLambdaExpression == null) {
                return;
            }
            ULambdaExpression contentArgument = uLambdaExpression;
            Iterable $this$forEach$iv = KotlinUtilsKt.findUnreferencedParameters(contentArgument);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtParameter ktParameter;
                UnreferencedParameter unreferencedParameter;
                block10: {
                    block9: {
                        unreferencedParameter = (UnreferencedParameter)element$iv;
                        boolean bl = false;
                        ktParameter = unreferencedParameter.getParameter();
                        if (ktParameter == null) break block9;
                        KtParameter it = ktParameter;
                        boolean bl2 = false;
                        Location location = context.getLocation((PsiElement)it);
                        ktParameter = location;
                        if (location != null) break block10;
                    }
                    ktParameter = context.getLocation((UElement)contentArgument);
                }
                KtParameter location = ktParameter;
                String name = unreferencedParameter.getName();
                JavaContext.report$default((JavaContext)context, (Issue)UnusedMaterial3ScaffoldPaddingParameter, (UElement)((UElement)node), (Location)location, (String)("Content padding parameter " + name + " is not used"), null, (int)16, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/material3/lint/ScaffoldPaddingDetector$Companion;", "", "()V", "UnusedMaterial3ScaffoldPaddingParameter", "Lcom/android/tools/lint/detector/api/Issue;", "getUnusedMaterial3ScaffoldPaddingParameter", "()Lcom/android/tools/lint/detector/api/Issue;", "material3-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnusedMaterial3ScaffoldPaddingParameter() {
            return UnusedMaterial3ScaffoldPaddingParameter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

