/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.KeyInfo;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u0015\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020\nJ\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020?J\u000e\u0010A\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\nJ\u0006\u0010B\u001a\u00020?J\u0006\u0010C\u001a\u00020?J\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EJ\u0010\u0010G\u001a\u0004\u0018\u00010\u00012\u0006\u0010=\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010=\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u0010\u0010H\u001a\u0004\u0018\u00010\u00012\u0006\u0010=\u001a\u00020\nJ\u0018\u0010H\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010;\u001a\u00020<J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010=\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010J\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\nJ\u000e\u0010K\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\nJ\u000e\u0010*\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\nJ\b\u0010L\u001a\u0004\u0018\u00010\u0001J\u0010\u0010M\u001a\u0004\u0018\u00010\u00012\u0006\u0010=\u001a\u00020\nJ\u000e\u0010+\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010-\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010N\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010O\u001a\u00020?2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010P\u001a\u00020?2\u0006\u0010=\u001a\u00020\nJ\u0006\u0010Q\u001a\u00020\nJ\u0006\u0010R\u001a\u00020?J\u0006\u0010S\u001a\u00020?J\u0006\u0010T\u001a\u00020?J\b\u0010U\u001a\u00020VH\u0016J\u0016\u0010W\u001a\u0004\u0018\u00010\u0001*\u00020%2\u0006\u0010=\u001a\u00020\nH\u0002J\u0016\u0010M\u001a\u0004\u0018\u00010\u0001*\u00020%2\u0006\u0010=\u001a\u00020\nH\u0002J\u0016\u0010X\u001a\u0004\u0018\u00010\u0001*\u00020%2\u0006\u0010=\u001a\u00020\nH\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\u001e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u0011\u0010 \u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\rR\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\tR\u0011\u0010)\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\tR\u0011\u0010*\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\tR\u0011\u0010+\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u001e\u0010-\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\rR\u0011\u0010/\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\rR\u0011\u00101\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\rR\u0011\u00103\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\rR\u0018\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000106X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00107R\u000e\u00108\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006Y"}, d2={"Landroidx/compose/runtime/SlotReader;", "", "table", "Landroidx/compose/runtime/SlotTable;", "(Landroidx/compose/runtime/SlotTable;)V", "<set-?>", "", "closed", "getClosed", "()Z", "", "currentEnd", "getCurrentEnd", "()I", "currentGroup", "getCurrentGroup", "currentSlot", "currentSlotEnd", "emptyCount", "groupAux", "getGroupAux", "()Ljava/lang/Object;", "groupEnd", "getGroupEnd", "groupKey", "getGroupKey", "groupNode", "getGroupNode", "groupObjectKey", "getGroupObjectKey", "groupSize", "getGroupSize", "groupSlotCount", "getGroupSlotCount", "groupSlotIndex", "getGroupSlotIndex", "groups", "", "groupsSize", "inEmpty", "getInEmpty", "isGroupEnd", "isNode", "nodeCount", "getNodeCount", "parent", "getParent", "parentNodes", "getParentNodes", "size", "getSize", "slot", "getSlot", "slots", "", "[Ljava/lang/Object;", "slotsSize", "getTable$runtime_release", "()Landroidx/compose/runtime/SlotTable;", "anchor", "Landroidx/compose/runtime/Anchor;", "index", "beginEmpty", "", "close", "containsMark", "endEmpty", "endGroup", "extractKeys", "", "Landroidx/compose/runtime/KeyInfo;", "get", "groupGet", "group", "hasMark", "hasObjectKey", "next", "node", "parentOf", "reposition", "restoreParent", "skipGroup", "skipToGroupEnd", "startGroup", "startNode", "toString", "", "aux", "objectKey", "runtime_release"})
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 4 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n*L\n1#1,3481:1\n1#2:3482\n4105#3,5:3483\n4105#3,5:3488\n4105#3,5:3493\n4105#3,5:3498\n4105#3,5:3503\n3359#4,6:3508\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotReader\n*L\n963#1:3483,5\n973#1:3488,5\n981#1:3493,5\n1000#1:3498,5\n1014#1:3503,5\n1056#1:3508,6\n*E\n"})
public final class SlotReader {
    @NotNull
    private final SlotTable table;
    @NotNull
    private final int[] groups;
    private final int groupsSize;
    @NotNull
    private final Object[] slots;
    private final int slotsSize;
    private boolean closed;
    private int currentGroup;
    private int currentEnd;
    private int parent;
    private int emptyCount;
    private int currentSlot;
    private int currentSlotEnd;

    public SlotReader(@NotNull SlotTable table) {
        this.table = table;
        this.groups = this.table.getGroups();
        this.groupsSize = this.table.getGroupsSize();
        this.slots = this.table.getSlots();
        this.slotsSize = this.table.getSlotsSize();
        this.currentEnd = this.groupsSize;
        this.parent = -1;
    }

    @NotNull
    public final SlotTable getTable$runtime_release() {
        return this.table;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final int getCurrentGroup() {
        return this.currentGroup;
    }

    public final int getCurrentEnd() {
        return this.currentEnd;
    }

    public final int getParent() {
        return this.parent;
    }

    public final int getSize() {
        return this.groupsSize;
    }

    public final int getSlot() {
        return this.currentSlot - SlotTableKt.access$slotAnchor(this.groups, this.parent);
    }

    public final int parent(int index) {
        return SlotTableKt.access$parentAnchor(this.groups, index);
    }

    public final boolean isNode() {
        return SlotTableKt.access$isNode(this.groups, this.currentGroup);
    }

    public final boolean isNode(int index) {
        return SlotTableKt.access$isNode(this.groups, index);
    }

    public final int getNodeCount() {
        return SlotTableKt.access$nodeCount(this.groups, this.currentGroup);
    }

    public final int nodeCount(int index) {
        return SlotTableKt.access$nodeCount(this.groups, index);
    }

    @Nullable
    public final Object node(int index) {
        return SlotTableKt.access$isNode(this.groups, index) ? this.node(this.groups, index) : null;
    }

    public final boolean isGroupEnd() {
        return this.getInEmpty() || this.currentGroup == this.currentEnd;
    }

    public final boolean getInEmpty() {
        return this.emptyCount > 0;
    }

    public final int getGroupSize() {
        return SlotTableKt.access$groupSize(this.groups, this.currentGroup);
    }

    public final int groupSize(int index) {
        return SlotTableKt.access$groupSize(this.groups, index);
    }

    public final int getGroupEnd() {
        return this.currentEnd;
    }

    public final int groupEnd(int index) {
        return index + SlotTableKt.access$groupSize(this.groups, index);
    }

    public final int getGroupKey() {
        return this.currentGroup < this.currentEnd ? SlotTableKt.access$key(this.groups, this.currentGroup) : 0;
    }

    public final int groupKey(int index) {
        return SlotTableKt.access$key(this.groups, index);
    }

    public final int getGroupSlotIndex() {
        return this.currentSlot - SlotTableKt.access$slotAnchor(this.groups, this.parent);
    }

    public final boolean hasObjectKey(int index) {
        return SlotTableKt.access$hasObjectKey(this.groups, index);
    }

    @Nullable
    public final Object getGroupObjectKey() {
        return this.currentGroup < this.currentEnd ? this.objectKey(this.groups, this.currentGroup) : null;
    }

    @Nullable
    public final Object groupObjectKey(int index) {
        return this.objectKey(this.groups, index);
    }

    @Nullable
    public final Object getGroupAux() {
        return this.currentGroup < this.currentEnd ? this.aux(this.groups, this.currentGroup) : Integer.valueOf(0);
    }

    @Nullable
    public final Object groupAux(int index) {
        return this.aux(this.groups, index);
    }

    @Nullable
    public final Object getGroupNode() {
        return this.currentGroup < this.currentEnd ? this.node(this.groups, this.currentGroup) : null;
    }

    public final int groupKey(@NotNull Anchor anchor) {
        return anchor.getValid() ? SlotTableKt.access$key(this.groups, this.table.anchorIndex(anchor)) : 0;
    }

    public final boolean hasMark(int index) {
        return SlotTableKt.access$hasMark(this.groups, index);
    }

    public final boolean containsMark(int index) {
        return SlotTableKt.access$containsMark(this.groups, index);
    }

    public final int getParentNodes() {
        return this.parent >= 0 ? SlotTableKt.access$nodeCount(this.groups, this.parent) : 0;
    }

    public final int parentOf(int index) {
        if (!(index >= 0 && index < this.groupsSize)) {
            boolean bl = false;
            String string = "Invalid group index " + index;
            throw new IllegalArgumentException(string.toString());
        }
        return SlotTableKt.access$parentAnchor(this.groups, index);
    }

    public final int getGroupSlotCount() {
        int current = this.currentGroup;
        int start = SlotTableKt.access$slotAnchor(this.groups, current);
        int next2 = current + 1;
        int end2 = next2 < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, next2) : this.slotsSize;
        return end2 - start;
    }

    @Nullable
    public final Object get(int index) {
        int slotIndex = this.currentSlot + index;
        boolean bl = false;
        return slotIndex < this.currentSlotEnd ? this.slots[slotIndex] : Composer.Companion.getEmpty();
    }

    @Nullable
    public final Object groupGet(int index) {
        return this.groupGet(this.currentGroup, index);
    }

    @Nullable
    public final Object groupGet(int group, int index) {
        int start = SlotTableKt.access$slotAnchor(this.groups, group);
        int next2 = group + 1;
        int end2 = next2 < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, next2) : this.slotsSize;
        int address = start + index;
        return address < end2 ? this.slots[address] : Composer.Companion.getEmpty();
    }

    @Nullable
    public final Object next() {
        if (this.emptyCount > 0 || this.currentSlot >= this.currentSlotEnd) {
            return Composer.Companion.getEmpty();
        }
        int n = this.currentSlot;
        this.currentSlot = n + 1;
        return this.slots[n];
    }

    public final void beginEmpty() {
        int n = this.emptyCount;
        this.emptyCount = n + 1;
    }

    public final void endEmpty() {
        if (!(this.emptyCount > 0)) {
            boolean bl = false;
            String string = "Unbalanced begin/end empty";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.emptyCount;
        this.emptyCount = n + -1;
    }

    public final void close() {
        this.closed = true;
        this.table.close$runtime_release(this);
    }

    public final void startGroup() {
        if (this.emptyCount <= 0) {
            if (!(SlotTableKt.access$parentAnchor(this.groups, this.currentGroup) == this.parent)) {
                boolean bl = false;
                String string = "Invalid slot table detected";
                throw new IllegalArgumentException(string.toString());
            }
            this.parent = this.currentGroup;
            this.currentEnd = this.currentGroup + SlotTableKt.access$groupSize(this.groups, this.currentGroup);
            int n = this.currentGroup;
            this.currentGroup = n + 1;
            int current = n;
            this.currentSlot = SlotTableKt.access$slotAnchor(this.groups, current);
            this.currentSlotEnd = current >= this.groupsSize - 1 ? this.slotsSize : SlotTableKt.access$dataAnchor(this.groups, current + 1);
        }
    }

    public final void startNode() {
        if (this.emptyCount <= 0) {
            if (!SlotTableKt.access$isNode(this.groups, this.currentGroup)) {
                boolean bl = false;
                String string = "Expected a node group";
                throw new IllegalArgumentException(string.toString());
            }
            this.startGroup();
        }
    }

    public final int skipGroup() {
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot skip while in an empty region";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int count = SlotTableKt.access$isNode(this.groups, this.currentGroup) ? 1 : SlotTableKt.access$nodeCount(this.groups, this.currentGroup);
        this.currentGroup += SlotTableKt.access$groupSize(this.groups, this.currentGroup);
        return count;
    }

    public final void skipToGroupEnd() {
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot skip the enclosing group while in an empty region";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.currentGroup = this.currentEnd;
    }

    public final void reposition(int index) {
        int parent;
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot reposition while in an empty region";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.currentGroup = index;
        this.parent = parent = index < this.groupsSize ? SlotTableKt.access$parentAnchor(this.groups, index) : -1;
        this.currentEnd = parent < 0 ? this.groupsSize : parent + SlotTableKt.access$groupSize(this.groups, parent);
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void restoreParent(int index) {
        int newCurrentEnd = index + SlotTableKt.access$groupSize(this.groups, index);
        int current = this.currentGroup;
        boolean value$iv = current >= index && current <= newCurrentEnd;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Index " + index + " is not a parent of " + current;
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.parent = index;
        this.currentEnd = newCurrentEnd;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void endGroup() {
        if (this.emptyCount == 0) {
            int parent;
            boolean value$iv = this.currentGroup == this.currentEnd;
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "endGroup() not called at the end of a group";
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            this.parent = parent = SlotTableKt.access$parentAnchor(this.groups, this.parent);
            this.currentEnd = parent < 0 ? this.groupsSize : parent + SlotTableKt.access$groupSize(this.groups, parent);
        }
    }

    @NotNull
    public final List<KeyInfo> extractKeys() {
        List result2 = new ArrayList();
        if (this.emptyCount > 0) {
            return result2;
        }
        int index = 0;
        for (int childIndex = this.currentGroup; childIndex < this.currentEnd; childIndex += SlotTableKt.access$groupSize(this.groups, childIndex)) {
            result2.add(new KeyInfo(SlotTableKt.access$key(this.groups, childIndex), this.objectKey(this.groups, childIndex), childIndex, SlotTableKt.access$isNode(this.groups, childIndex) ? 1 : SlotTableKt.access$nodeCount(this.groups, childIndex), index++));
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return "SlotReader(current=" + this.currentGroup + ", key=" + this.getGroupKey() + ", parent=" + this.parent + ", end=" + this.currentEnd + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Anchor anchor(int index) {
        Anchor anchor;
        void $this$getOrAdd$iv;
        ArrayList<Anchor> arrayList = this.table.getAnchors$runtime_release();
        int effectiveSize$iv = this.groupsSize;
        boolean $i$f$getOrAdd = false;
        int location$iv = SlotTableKt.access$search((ArrayList)$this$getOrAdd$iv, index, effectiveSize$iv);
        if (location$iv < 0) {
            boolean bl = false;
            Anchor anchor$iv = new Anchor(index);
            $this$getOrAdd$iv.add(-(location$iv + 1), anchor$iv);
            anchor = anchor$iv;
        } else {
            anchor = (Anchor)$this$getOrAdd$iv.get(location$iv);
        }
        return anchor;
    }

    public static /* synthetic */ Anchor anchor$default(SlotReader slotReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = slotReader.currentGroup;
        }
        return slotReader.anchor(n);
    }

    private final Object node(int[] $this$node, int index) {
        return SlotTableKt.access$isNode($this$node, index) ? this.slots[SlotTableKt.access$nodeIndex($this$node, index)] : Composer.Companion.getEmpty();
    }

    private final Object aux(int[] $this$aux, int index) {
        return SlotTableKt.access$hasAux($this$aux, index) ? this.slots[SlotTableKt.access$auxIndex($this$aux, index)] : Composer.Companion.getEmpty();
    }

    private final Object objectKey(int[] $this$objectKey, int index) {
        return SlotTableKt.access$hasObjectKey($this$objectKey, index) ? this.slots[SlotTableKt.access$objectKeyIndex($this$objectKey, index)] : null;
    }
}

