/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.changelist;

import androidx.compose.runtime.Applier;
import androidx.compose.runtime.InternalComposeApi;
import androidx.compose.runtime.RememberManager;
import androidx.compose.runtime.SlotWriter;
import androidx.compose.runtime.changelist.Operation;
import androidx.compose.runtime.changelist.OperationArgContainer;
import androidx.compose.runtime.changelist.OperationsDebugStringFormattable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0000\u0018\u0000 J2\u00020\u0001:\u0003JKLB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J&\u0010\u001c\u001a\u00020\u00162\u001b\u0010\u001d\u001a\u0017\u0012\b\u0012\u00060\u001fR\u00020\u0000\u0012\u0004\u0012\u00020\u00160\u001e\u00a2\u0006\u0002\b H\u0086\bJ\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\"\u0010#\u001a\u00020\u00162\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J&\u0010*\u001a\u00020\u00162\u001b\u0010+\u001a\u0017\u0012\b\u0012\u00060\u001fR\u00020\u0000\u0012\u0004\u0012\u00020\u00160\u001e\u00a2\u0006\u0002\b H\u0086\bJ\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020-J\b\u0010/\u001a\u00020\rH\u0002J\u0006\u00100\u001a\u00020\u0016J\u000e\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u0000J\u000e\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\rJ:\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\r2\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u00160\u001e\u00a2\u0006\u0002\b H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001J\u0010\u00107\u001a\u00020\u00162\u0006\u00104\u001a\u00020\rH\u0007J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0016J\b\u0010;\u001a\u000209H\u0017J\u001d\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020>H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010@J!\u0010A\u001a\u00020\u00062\n\u0010=\u001a\u0006\u0012\u0002\b\u00030BH\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bC\u0010@J\u0018\u0010D\u001a\u000209*\u00060\u001fR\u00020\u00002\u0006\u0010:\u001a\u000209H\u0002J\u0016\u0010E\u001a\u000209*\u0004\u0018\u00010\t2\u0006\u0010:\u001a\u000209H\u0002J\f\u0010F\u001a\u000209*\u000209H\u0002J \u0010G\u001a\u000209\"\u0004\b\u0000\u0010H*\b\u0012\u0004\u0012\u0002HH0I2\u0006\u0010:\u001a\u000209H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006M"}, d2={"Landroidx/compose/runtime/changelist/Operations;", "Landroidx/compose/runtime/changelist/OperationsDebugStringFormattable;", "()V", "intArgs", "", "intArgsSize", "", "objectArgs", "", "", "[Ljava/lang/Object;", "objectArgsSize", "opCodes", "Landroidx/compose/runtime/changelist/Operation;", "[Landroidx/compose/runtime/changelist/Operation;", "opCodesSize", "pushedIntMask", "pushedObjectMask", "size", "getSize", "()I", "clear", "", "createExpectedArgMask", "paramCount", "determineNewSize", "currentSize", "requiredSize", "drain", "sink", "Lkotlin/Function1;", "Landroidx/compose/runtime/changelist/Operations$OpIterator;", "Lkotlin/ExtensionFunctionType;", "ensureIntArgsSizeAtLeast", "ensureObjectArgsSizeAtLeast", "executeAndFlushAllPendingOperations", "applier", "Landroidx/compose/runtime/Applier;", "slots", "Landroidx/compose/runtime/SlotWriter;", "rememberManager", "Landroidx/compose/runtime/RememberManager;", "forEach", "action", "isEmpty", "", "isNotEmpty", "peekOperation", "pop", "popInto", "other", "push", "operation", "args", "Landroidx/compose/runtime/changelist/Operations$WriteScope;", "pushOp", "toDebugString", "", "linePrefix", "toString", "topIntIndexOf", "parameter", "Landroidx/compose/runtime/changelist/Operation$IntParameter;", "topIntIndexOf-w8GmfQM", "(I)I", "topObjectIndexOf", "Landroidx/compose/runtime/changelist/Operation$ObjectParameter;", "topObjectIndexOf-31yXWZQ", "currentOpToDebugString", "formatOpArgumentToString", "indent", "toCollectionString", "T", "", "Companion", "OpIterator", "WriteScope", "runtime_release"})
@SourceDebugExtension(value={"SMAP\nOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operations.kt\nandroidx/compose/runtime/changelist/Operations\n*L\n1#1,473:1\n292#1,7:474\n281#1:481\n292#1,7:482\n282#1,2:489\n292#1,7:491\n*S KotlinDebug\n*F\n+ 1 Operations.kt\nandroidx/compose/runtime/changelist/Operations\n*L\n281#1:474,7\n305#1:481\n305#1:482,7\n305#1:489,2\n404#1:491,7\n*E\n"})
public final class Operations
implements OperationsDebugStringFormattable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Operation[] opCodes = new Operation[16];
    private int opCodesSize;
    @NotNull
    private int[] intArgs = new int[16];
    private int intArgsSize;
    @NotNull
    private Object[] objectArgs = new Object[16];
    private int objectArgsSize;
    private int pushedIntMask;
    private int pushedObjectMask;
    private static final int MaxResizeAmount = 1024;
    public static final int InitialCapacity = 16;

    public final int getSize() {
        return this.opCodesSize;
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    public final boolean isNotEmpty() {
        return this.getSize() != 0;
    }

    public final void clear() {
        this.opCodesSize = 0;
        this.intArgsSize = 0;
        ArraysKt.fill((Object[])this.objectArgs, null, (int)0, (int)this.objectArgsSize);
        this.objectArgsSize = 0;
    }

    @InternalComposeApi
    public final void pushOp(@NotNull Operation operation) {
        this.pushedIntMask = 0;
        this.pushedObjectMask = 0;
        if (this.opCodesSize == this.opCodes.length) {
            int resizeAmount = RangesKt.coerceAtMost((int)this.opCodesSize, (int)1024);
            Operation[] operationArray = Arrays.copyOf(this.opCodes, this.opCodesSize + resizeAmount);
            Intrinsics.checkNotNullExpressionValue((Object)operationArray, (String)"copyOf(this, newSize)");
            this.opCodes = operationArray;
        }
        this.ensureIntArgsSizeAtLeast(this.intArgsSize + operation.getInts());
        this.ensureObjectArgsSizeAtLeast(this.objectArgsSize + operation.getObjects());
        int n = this.opCodesSize;
        this.opCodesSize = n + 1;
        this.opCodes[n] = operation;
        this.intArgsSize += operation.getInts();
        this.objectArgsSize += operation.getObjects();
    }

    private final int determineNewSize(int currentSize, int requiredSize) {
        int resizeAmount = RangesKt.coerceAtMost((int)currentSize, (int)1024);
        return RangesKt.coerceAtLeast((int)(currentSize + resizeAmount), (int)requiredSize);
    }

    private final void ensureIntArgsSizeAtLeast(int requiredSize) {
        int currentSize = this.intArgs.length;
        if (requiredSize > currentSize) {
            int[] nArray = Arrays.copyOf(this.intArgs, this.determineNewSize(currentSize, requiredSize));
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this.intArgs = nArray;
        }
    }

    private final void ensureObjectArgsSizeAtLeast(int requiredSize) {
        int currentSize = this.objectArgs.length;
        if (requiredSize > currentSize) {
            Object[] objectArray = Arrays.copyOf(this.objectArgs, this.determineNewSize(currentSize, requiredSize));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
            this.objectArgs = objectArray;
        }
    }

    public final void push(@NotNull Operation operation) {
        if (!(operation.getInts() == 0 && operation.getObjects() == 0)) {
            boolean bl = false;
            String string = "Cannot push " + operation + " without arguments because it expects " + operation.getInts() + " ints and " + operation.getObjects() + " objects.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pushOp(operation);
    }

    public final void push(@NotNull Operation operation, @NotNull Function1<? super WriteScope, Unit> args) {
        boolean $i$f$push = false;
        this.pushOp(operation);
        args.invoke((Object)WriteScope.box-impl(WriteScope.constructor-impl(this)));
        if (!(this.pushedIntMask == this.createExpectedArgMask(operation.getInts()) && this.pushedObjectMask == this.createExpectedArgMask(operation.getObjects()))) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            boolean bl = false;
            int missingIntCount = 0;
            StringBuilder $this$push_u24lambda_u246_u24lambda_u243 = stringBuilder2 = new StringBuilder();
            boolean bl2 = false;
            int n = operation.getInts();
            for (int i = 0; i < n; ++i) {
                int arg = i;
                boolean bl3 = false;
                if ((1 << arg & this.pushedIntMask) == 0) continue;
                if (missingIntCount > 0) {
                    $this$push_u24lambda_u246_u24lambda_u243.append(", ");
                }
                $this$push_u24lambda_u246_u24lambda_u243.append(operation.intParamName-w8GmfQM(Operation.IntParameter.constructor-impl(arg)));
                ++missingIntCount;
            }
            String string = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String missingInts = string;
            int missingObjectCount = 0;
            StringBuilder $this$push_u24lambda_u246_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl4 = false;
            int n2 = operation.getObjects();
            for (int i = 0; i < n2; ++i) {
                int arg = i;
                boolean bl5 = false;
                if ((1 << arg & this.pushedObjectMask) == 0) continue;
                if (missingIntCount > 0) {
                    $this$push_u24lambda_u246_u24lambda_u245.append(", ");
                }
                $this$push_u24lambda_u246_u24lambda_u245.append(operation.objectParamName-31yXWZQ(Operation.ObjectParameter.constructor-impl(arg)));
                ++missingObjectCount;
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String missingObjects = string2;
            String string3 = "Error while pushing " + operation + ". Not all arguments were provided. Missing " + missingIntCount + " int arguments (" + missingInts + ") and " + missingObjectCount + " object arguments (" + missingObjects + ").";
            throw new IllegalStateException(string3.toString());
        }
    }

    private final int createExpectedArgMask(int paramCount) {
        return paramCount == 0 ? 0 : -1 >>> 32 - paramCount;
    }

    public final void pop() {
        int it;
        if (this.isEmpty()) {
            throw new NoSuchElementException("Cannot pop(), because the stack is empty.");
        }
        this.opCodesSize += -1;
        Operation operation = this.opCodes[this.opCodesSize];
        Intrinsics.checkNotNull((Object)operation);
        Operation op = operation;
        this.opCodes[this.opCodesSize] = null;
        int n = op.getObjects();
        int n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            this.objectArgsSize += -1;
            this.objectArgs[this.objectArgsSize] = null;
        }
        n = op.getInts();
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            this.intArgsSize += -1;
            this.intArgs[this.intArgsSize] = 0;
        }
    }

    public final void popInto(@NotNull Operations other) {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Cannot pop(), because the stack is empty.");
        }
        this.opCodesSize += -1;
        Operation operation = this.opCodes[this.opCodesSize];
        Intrinsics.checkNotNull((Object)operation);
        Operation op = operation;
        this.opCodes[this.opCodesSize] = null;
        other.pushOp(op);
        int thisObjIdx = 0;
        thisObjIdx = this.objectArgsSize;
        int otherObjIdx = 0;
        otherObjIdx = other.objectArgsSize;
        int n = op.getObjects();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            other.objectArgs[otherObjIdx += -1] = this.objectArgs[thisObjIdx += -1];
            this.objectArgs[thisObjIdx] = null;
        }
        int thisIntIdx = 0;
        thisIntIdx = this.intArgsSize;
        int otherIntIdx = 0;
        otherIntIdx = other.intArgsSize;
        int n3 = op.getInts();
        int n4 = 0;
        while (n4 < n3) {
            int it = n4++;
            boolean bl = false;
            other.intArgs[otherIntIdx += -1] = this.intArgs[thisIntIdx += -1];
            this.intArgs[thisIntIdx] = 0;
        }
        this.objectArgsSize -= op.getObjects();
        this.intArgsSize -= op.getInts();
    }

    public final void drain(@NotNull Function1<? super OpIterator, Unit> sink) {
        boolean $i$f$drain = false;
        Operations this_$iv = this;
        boolean $i$f$forEach = false;
        if (this_$iv.isNotEmpty()) {
            OpIterator iterator$iv = this_$iv.new OpIterator();
            do {
                sink.invoke((Object)iterator$iv);
            } while (iterator$iv.next());
        }
        this.clear();
    }

    public final void forEach(@NotNull Function1<? super OpIterator, Unit> action) {
        boolean $i$f$forEach = false;
        if (this.isNotEmpty()) {
            OpIterator iterator2 = new OpIterator();
            do {
                action.invoke((Object)iterator2);
            } while (iterator2.next());
        }
    }

    public final void executeAndFlushAllPendingOperations(@NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
        Operations this_$iv = this;
        boolean $i$f$drain = false;
        Operations this_$iv$iv = this_$iv;
        boolean $i$f$forEach = false;
        if (this_$iv$iv.isNotEmpty()) {
            OpIterator iterator$iv$iv = this_$iv$iv.new OpIterator();
            do {
                OpIterator $this$executeAndFlushAllPendingOperations_u24lambda_u2412 = iterator$iv$iv;
                boolean bl = false;
                Operation $this$executeAndFlushAllPendingOperations_u24lambda_u2412_u24lambda_u2411 = $this$executeAndFlushAllPendingOperations_u24lambda_u2412.getOperation();
                boolean bl2 = false;
                $this$executeAndFlushAllPendingOperations_u24lambda_u2412_u24lambda_u2411.execute($this$executeAndFlushAllPendingOperations_u24lambda_u2412, applier, slots, rememberManager);
            } while (iterator$iv$iv.next());
        }
        this_$iv.clear();
    }

    private final String indent(String $this$indent) {
        return $this$indent + "    ";
    }

    private final Operation peekOperation() {
        Operation operation = this.opCodes[this.opCodesSize - 1];
        Intrinsics.checkNotNull((Object)operation);
        return operation;
    }

    private final int topIntIndexOf-w8GmfQM(int parameter) {
        return this.intArgsSize - this.peekOperation().getInts() + parameter;
    }

    private final int topObjectIndexOf-31yXWZQ(int parameter) {
        return this.objectArgsSize - this.peekOperation().getObjects() + parameter;
    }

    @Deprecated(message="toString() will return the default implementation from Any. Did you mean to use toDebugString()?", replaceWith=@ReplaceWith(expression="toDebugString()", imports={}))
    @NotNull
    public String toString() {
        return super.toString();
    }

    @Override
    @NotNull
    public String toDebugString(@NotNull String linePrefix) {
        StringBuilder stringBuilder;
        StringBuilder $this$toDebugString_u24lambda_u2414 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int opNumber = 0;
        opNumber = 1;
        Operations this_$iv = this;
        boolean $i$f$forEach = false;
        if (this_$iv.isNotEmpty()) {
            OpIterator iterator$iv = this_$iv.new OpIterator();
            do {
                OpIterator $this$toDebugString_u24lambda_u2414_u24lambda_u2413 = iterator$iv;
                boolean bl2 = false;
                $this$toDebugString_u24lambda_u2414.append(linePrefix);
                int n = opNumber;
                opNumber = n + 1;
                $this$toDebugString_u24lambda_u2414.append(n);
                $this$toDebugString_u24lambda_u2414.append(". ");
                StringBuilder stringBuilder2 = $this$toDebugString_u24lambda_u2414.append(this.currentOpToDebugString($this$toDebugString_u24lambda_u2414_u24lambda_u2413, linePrefix));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            } while (iterator$iv.next());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String currentOpToDebugString(OpIterator $this$currentOpToDebugString, String linePrefix) {
        String string;
        Operation operation = $this$currentOpToDebugString.getOperation();
        if (operation.getInts() == 0 && operation.getObjects() == 0) {
            string = operation.getName();
        } else {
            String name;
            int param;
            int offset;
            int n;
            StringBuilder stringBuilder;
            StringBuilder $this$currentOpToDebugString_u24lambda_u2417 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$currentOpToDebugString_u24lambda_u2417.append(operation.getName());
            $this$currentOpToDebugString_u24lambda_u2417.append('(');
            boolean isFirstParam = false;
            isFirstParam = true;
            String argLinePrefix = this.indent(linePrefix);
            int n2 = operation.getInts();
            for (n = 0; n < n2; ++n) {
                offset = n;
                boolean bl2 = false;
                param = Operation.IntParameter.constructor-impl(offset);
                name = operation.intParamName-w8GmfQM(param);
                if (!isFirstParam) {
                    $this$currentOpToDebugString_u24lambda_u2417.append(", ");
                } else {
                    isFirstParam = false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$currentOpToDebugString_u24lambda_u2417.append('\n'), (String)"append('\\n')");
                $this$currentOpToDebugString_u24lambda_u2417.append(argLinePrefix);
                $this$currentOpToDebugString_u24lambda_u2417.append(name);
                $this$currentOpToDebugString_u24lambda_u2417.append(" = ");
                $this$currentOpToDebugString_u24lambda_u2417.append($this$currentOpToDebugString.getInt-w8GmfQM(param));
            }
            n2 = operation.getObjects();
            for (n = 0; n < n2; ++n) {
                offset = n;
                boolean bl3 = false;
                param = Operation.ObjectParameter.constructor-impl(offset);
                name = operation.objectParamName-31yXWZQ(param);
                if (!isFirstParam) {
                    $this$currentOpToDebugString_u24lambda_u2417.append(", ");
                } else {
                    isFirstParam = false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$currentOpToDebugString_u24lambda_u2417.append('\n'), (String)"append('\\n')");
                $this$currentOpToDebugString_u24lambda_u2417.append(argLinePrefix);
                $this$currentOpToDebugString_u24lambda_u2417.append(name);
                $this$currentOpToDebugString_u24lambda_u2417.append(" = ");
                $this$currentOpToDebugString_u24lambda_u2417.append(this.formatOpArgumentToString($this$currentOpToDebugString.getObject-31yXWZQ(param), argLinePrefix));
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$currentOpToDebugString_u24lambda_u2417.append('\n'), (String)"append('\\n')");
            $this$currentOpToDebugString_u24lambda_u2417.append(linePrefix);
            $this$currentOpToDebugString_u24lambda_u2417.append(")");
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        }
        return string;
    }

    private final String formatOpArgumentToString(Object $this$formatOpArgumentToString, String linePrefix) {
        Object object = $this$formatOpArgumentToString;
        return object == null ? "null" : (object instanceof Object[] ? this.toCollectionString(ArraysKt.asIterable((Object[])((Object[])$this$formatOpArgumentToString)), linePrefix) : (object instanceof int[] ? this.toCollectionString(ArraysKt.asIterable((int[])((int[])$this$formatOpArgumentToString)), linePrefix) : (object instanceof long[] ? this.toCollectionString(ArraysKt.asIterable((long[])((long[])$this$formatOpArgumentToString)), linePrefix) : (object instanceof float[] ? this.toCollectionString(ArraysKt.asIterable((float[])((float[])$this$formatOpArgumentToString)), linePrefix) : (object instanceof double[] ? this.toCollectionString(ArraysKt.asIterable((double[])((double[])$this$formatOpArgumentToString)), linePrefix) : (object instanceof Iterable ? this.toCollectionString((Iterable)$this$formatOpArgumentToString, linePrefix) : (object instanceof OperationsDebugStringFormattable ? ((OperationsDebugStringFormattable)$this$formatOpArgumentToString).toDebugString(linePrefix) : $this$formatOpArgumentToString.toString())))))));
    }

    private final <T> String toCollectionString(Iterable<? extends T> $this$toCollectionString, String linePrefix) {
        return CollectionsKt.joinToString$default($this$toCollectionString, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)new Function1<T, CharSequence>(this, linePrefix){
            final /* synthetic */ Operations this$0;
            final /* synthetic */ String $linePrefix;
            {
                this.this$0 = $receiver;
                this.$linePrefix = $linePrefix;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(T it) {
                return Operations.access$formatOpArgumentToString(this.this$0, it, this.$linePrefix);
            }
        }, (int)24, null);
    }

    public static final /* synthetic */ String access$formatOpArgumentToString(Operations $this, Object $receiver, String linePrefix) {
        return $this.formatOpArgumentToString($receiver, linePrefix);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/runtime/changelist/Operations$Companion;", "", "()V", "InitialCapacity", "", "MaxResizeAmount", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0012H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Landroidx/compose/runtime/changelist/Operations$OpIterator;", "Landroidx/compose/runtime/changelist/OperationArgContainer;", "(Landroidx/compose/runtime/changelist/Operations;)V", "intIdx", "", "objIdx", "opIdx", "operation", "Landroidx/compose/runtime/changelist/Operation;", "getOperation", "()Landroidx/compose/runtime/changelist/Operation;", "getInt", "parameter", "Landroidx/compose/runtime/changelist/Operation$IntParameter;", "getInt-w8GmfQM", "(I)I", "getObject", "T", "Landroidx/compose/runtime/changelist/Operation$ObjectParameter;", "getObject-31yXWZQ", "(I)Ljava/lang/Object;", "next", "", "runtime_release"})
    public final class OpIterator
    implements OperationArgContainer {
        private int opIdx;
        private int intIdx;
        private int objIdx;

        public final boolean next() {
            if (this.opIdx >= Operations.this.opCodesSize) {
                return false;
            }
            Operation op = this.getOperation();
            this.intIdx += op.getInts();
            this.objIdx += op.getObjects();
            int n = this.opIdx;
            this.opIdx = n + 1;
            return this.opIdx < Operations.this.opCodesSize;
        }

        @NotNull
        public final Operation getOperation() {
            Operation operation = Operations.this.opCodes[this.opIdx];
            Intrinsics.checkNotNull((Object)operation);
            return operation;
        }

        @Override
        public int getInt-w8GmfQM(int parameter) {
            return Operations.this.intArgs[this.intIdx + parameter];
        }

        @Override
        public <T> T getObject-31yXWZQ(int parameter) {
            return (T)Operations.this.objectArgs[this.objIdx + parameter];
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087@\u0018\u00002\u00020\u0001B\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001a\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001c2\u0006\u0010\u0017\u001a\u0002H\u001b\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0088\u0001\u0002\u0092\u0001\u00020\u0003\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006#"}, d2={"Landroidx/compose/runtime/changelist/Operations$WriteScope;", "", "stack", "Landroidx/compose/runtime/changelist/Operations;", "constructor-impl", "(Landroidx/compose/runtime/changelist/Operations;)Landroidx/compose/runtime/changelist/Operations;", "operation", "Landroidx/compose/runtime/changelist/Operation;", "getOperation-impl", "(Landroidx/compose/runtime/changelist/Operations;)Landroidx/compose/runtime/changelist/Operation;", "equals", "", "other", "equals-impl", "(Landroidx/compose/runtime/changelist/Operations;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Landroidx/compose/runtime/changelist/Operations;)I", "setInt", "", "parameter", "Landroidx/compose/runtime/changelist/Operation$IntParameter;", "value", "setInt-A6tL2VI", "(Landroidx/compose/runtime/changelist/Operations;II)V", "setObject", "T", "Landroidx/compose/runtime/changelist/Operation$ObjectParameter;", "setObject-DKhxnng", "(Landroidx/compose/runtime/changelist/Operations;ILjava/lang/Object;)V", "toString", "", "toString-impl", "(Landroidx/compose/runtime/changelist/Operations;)Ljava/lang/String;", "runtime_release"})
    public static final class WriteScope {
        @NotNull
        private final Operations stack;

        @NotNull
        public static final Operation getOperation-impl(Operations arg0) {
            return arg0.peekOperation();
        }

        public static final void setInt-A6tL2VI(Operations arg0, int parameter, int value) {
            Operations $this$setInt_A6tL2VI_u24lambda_u241 = arg0;
            boolean bl = false;
            int mask = 1 << parameter;
            if (!(($this$setInt_A6tL2VI_u24lambda_u241.pushedIntMask & mask) == 0)) {
                boolean bl2 = false;
                String string = "Already pushed argument " + WriteScope.getOperation-impl(arg0).intParamName-w8GmfQM(parameter);
                throw new IllegalStateException(string.toString());
            }
            $this$setInt_A6tL2VI_u24lambda_u241.pushedIntMask = $this$setInt_A6tL2VI_u24lambda_u241.pushedIntMask | mask;
            ((Operations)$this$setInt_A6tL2VI_u24lambda_u241).intArgs[((Operations)$this$setInt_A6tL2VI_u24lambda_u241).topIntIndexOf-w8GmfQM((int)parameter)] = value;
        }

        public static final <T> void setObject-DKhxnng(Operations arg0, int parameter, T value) {
            Operations $this$setObject_DKhxnng_u24lambda_u243 = arg0;
            boolean bl = false;
            int mask = 1 << parameter;
            if (!(($this$setObject_DKhxnng_u24lambda_u243.pushedObjectMask & mask) == 0)) {
                boolean bl2 = false;
                String string = "Already pushed argument " + WriteScope.getOperation-impl(arg0).objectParamName-31yXWZQ(parameter);
                throw new IllegalStateException(string.toString());
            }
            $this$setObject_DKhxnng_u24lambda_u243.pushedObjectMask = $this$setObject_DKhxnng_u24lambda_u243.pushedObjectMask | mask;
            ((Operations)$this$setObject_DKhxnng_u24lambda_u243).objectArgs[((Operations)$this$setObject_DKhxnng_u24lambda_u243).topObjectIndexOf-31yXWZQ((int)parameter)] = value;
        }

        public static String toString-impl(Operations arg0) {
            return "WriteScope(stack=" + arg0 + ')';
        }

        public String toString() {
            return WriteScope.toString-impl(this.stack);
        }

        public static int hashCode-impl(Operations arg0) {
            return arg0.hashCode();
        }

        public int hashCode() {
            return WriteScope.hashCode-impl(this.stack);
        }

        public static boolean equals-impl(Operations arg0, Object other) {
            if (!(other instanceof WriteScope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((WriteScope)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return WriteScope.equals-impl(this.stack, other);
        }

        private /* synthetic */ WriteScope(Operations stack) {
            this.stack = stack;
        }

        @NotNull
        public static Operations constructor-impl(@NotNull Operations stack) {
            return stack;
        }

        public static final /* synthetic */ WriteScope box-impl(Operations v) {
            return new WriteScope(v);
        }

        public final /* synthetic */ Operations unbox-impl() {
            return this.stack;
        }

        public static final boolean equals-impl0(Operations p1, Operations p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }
    }
}

