/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.ActualJvm_jvmKt;
import androidx.compose.runtime.collection.IdentityArraySet;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0006\u0010\u0019\u001a\u00020\u0014J\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u001c\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J(\u0010\u001e\u001a\u00020\u00102\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100 H\u0086\b\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J(\u0010!\u001a\u00020\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140 H\u0086\b\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0012\u0010\"\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0016\u0010&\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0010H\u0016J\u0006\u0010)\u001a\u00020\u0010J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0096\u0002J\u0013\u0010,\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010-\u001a\u00020\u00142\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100 H\u0086\bJ\b\u0010/\u001a\u000200H\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR0\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n2\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u00061"}, d2={"Landroidx/compose/runtime/collection/IdentityArraySet;", "T", "", "", "()V", "<set-?>", "", "size", "getSize", "()I", "", "values", "getValues", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "add", "", "value", "(Ljava/lang/Object;)Z", "addAll", "", "collection", "", "checkIndexBounds", "index", "clear", "contains", "element", "containsAll", "elements", "fastAny", "block", "Lkotlin/Function1;", "fastForEach", "find", "findExactIndex", "midIndex", "valueHash", "get", "(I)Ljava/lang/Object;", "isEmpty", "isNotEmpty", "iterator", "", "remove", "removeValueIf", "predicate", "toString", "", "runtime_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIdentityArraySet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityArraySet.kt\nandroidx/compose/runtime/collection/IdentityArraySet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,402:1\n1726#2,3:403\n*S KotlinDebug\n*F\n+ 1 IdentityArraySet.kt\nandroidx/compose/runtime/collection/IdentityArraySet\n*L\n378#1:403,3\n*E\n"})
public final class IdentityArraySet<T>
implements Set<T>,
KMappedMarker {
    private int size;
    @NotNull
    private Object[] values = new Object[16];
    public static final int $stable = 8;

    public int getSize() {
        return this.size;
    }

    @NotNull
    public final Object[] getValues() {
        return this.values;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.find(element) >= 0;
    }

    @NotNull
    public final T get(int index) {
        this.checkIndexBounds(index);
        Object object = this.values[index];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
        return (T)object;
    }

    @Override
    public final boolean add(@NotNull T value) {
        int index = 0;
        int size = this.size();
        Object[] values2 = this.values;
        if (size > 0) {
            index = this.find(value);
            if (index >= 0) {
                return false;
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        if (size == values2.length) {
            Object[] newSorted = new Object[values2.length * 2];
            ArraysKt.copyInto((Object[])values2, (Object[])newSorted, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto$default((Object[])values2, (Object[])newSorted, (int)0, (int)0, (int)insertIndex, (int)6, null);
            this.values = newSorted;
        } else {
            ArraysKt.copyInto((Object[])values2, (Object[])values2, (int)(insertIndex + 1), (int)insertIndex, (int)size);
        }
        this.values[insertIndex] = value;
        int n = this.size();
        this.size = n + 1;
        return true;
    }

    @Override
    public final void clear() {
        ArraysKt.fill$default((Object[])this.values, null, (int)0, (int)0, (int)6, null);
        this.size = 0;
    }

    public final void fastForEach(@NotNull Function1<? super T, Unit> block) {
        boolean $i$f$fastForEach = false;
        Object[] values2 = this.getValues();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object object = values2[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
            block.invoke(object);
        }
    }

    public final boolean fastAny(@NotNull Function1<? super T, Boolean> block) {
        boolean $i$f$fastAny = false;
        int size = this.size();
        if (size == 0) {
            return false;
        }
        Object[] values2 = this.getValues();
        for (int i = 0; i < size; ++i) {
            Object object = values2[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
            if (!((Boolean)block.invoke(object)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public final void addAll(@NotNull Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return;
        }
        if (!(collection instanceof IdentityArraySet)) {
            for (T value : collection) {
                this.add(value);
            }
        } else {
            boolean elementsInOrder;
            int otherSize;
            Object[] thisValues = this.values;
            Object[] otherValues = ((IdentityArraySet)collection).values;
            int thisSize = this.size();
            int combinedSize = thisSize + (otherSize = ((IdentityArraySet)collection).size());
            boolean needsResize = this.values.length < combinedSize;
            boolean bl = elementsInOrder = thisSize == 0 || ActualJvm_jvmKt.identityHashCode(thisValues[thisSize - 1]) < ActualJvm_jvmKt.identityHashCode(otherValues[0]);
            if (!needsResize && elementsInOrder) {
                ArraysKt.copyInto((Object[])otherValues, (Object[])thisValues, (int)thisSize, (int)0, (int)otherSize);
                this.size = this.size() + otherSize;
            } else {
                Object[] newArray = needsResize ? new Object[thisSize > otherSize ? thisSize * 2 : otherSize * 2] : thisValues;
                int thisIndex = thisSize - 1;
                int otherIndex = otherSize - 1;
                int nextInsertIndex = combinedSize - 1;
                while (true) {
                    Object object;
                    if (thisIndex < 0) {
                        if (otherIndex < 0) break;
                    }
                    if (thisIndex < 0) {
                        object = otherValues[otherIndex--];
                    } else if (otherIndex < 0) {
                        object = thisValues[thisIndex--];
                    } else {
                        Object thisValue = thisValues[thisIndex];
                        Object otherValue = otherValues[otherIndex];
                        int thisHash = ActualJvm_jvmKt.identityHashCode(thisValue);
                        int otherHash = ActualJvm_jvmKt.identityHashCode(otherValue);
                        if (thisHash > otherHash) {
                            --thisIndex;
                            object = thisValue;
                        } else if (thisHash < otherHash) {
                            --otherIndex;
                            object = otherValue;
                        } else if (thisValue == otherValue) {
                            --thisIndex;
                            --otherIndex;
                            object = thisValue;
                        } else {
                            Object value;
                            int i = thisIndex - 1;
                            boolean foundDuplicate = false;
                            while (i >= 0 && ActualJvm_jvmKt.identityHashCode(value = thisValues[i--]) == otherHash) {
                                if (otherValue != value) continue;
                                foundDuplicate = true;
                                break;
                            }
                            if (foundDuplicate) {
                                --otherIndex;
                                continue;
                            }
                            --otherIndex;
                            object = otherValue;
                        }
                    }
                    Object nextValue = object;
                    newArray[nextInsertIndex--] = nextValue;
                }
                if (nextInsertIndex >= 0) {
                    ArraysKt.copyInto((Object[])newArray, (Object[])newArray, (int)0, (int)(nextInsertIndex + 1), (int)combinedSize);
                }
                int newSize = combinedSize - (nextInsertIndex + 1);
                ArraysKt.fill((Object[])newArray, null, (int)newSize, (int)combinedSize);
                this.values = newArray;
                this.size = newSize;
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final boolean isNotEmpty() {
        return this.size() > 0;
    }

    @Override
    public final boolean remove(@Nullable T value) {
        if (value == null) {
            return false;
        }
        int index = this.find(value);
        Object[] values2 = this.values;
        int size = this.size();
        if (index >= 0) {
            if (index < size - 1) {
                ArraysKt.copyInto((Object[])values2, (Object[])values2, (int)index, (int)(index + 1), (int)size);
            }
            values2[size - 1] = null;
            int n = this.size();
            this.size = n + -1;
            return true;
        }
        return false;
    }

    public final void removeValueIf(@NotNull Function1<? super T, Boolean> predicate) {
        int i;
        boolean $i$f$removeValueIf = false;
        Object[] values2 = this.getValues();
        int size = this.size();
        int destinationIndex = 0;
        for (i = 0; i < size; ++i) {
            Object item;
            Intrinsics.checkNotNull((Object)values2[i], (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
            if (((Boolean)predicate.invoke(item)).booleanValue()) continue;
            if (destinationIndex != i) {
                values2[destinationIndex] = item;
            }
            ++destinationIndex;
        }
        for (i = destinationIndex; i < size; ++i) {
            values2[i] = null;
        }
        this.size = destinationIndex;
    }

    private final int find(Object value) {
        int low = 0;
        int high = this.size() - 1;
        int valueIdentity = ActualJvm_jvmKt.identityHashCode(value);
        Object[] values2 = this.values;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = values2[mid];
            int midIdentity = ActualJvm_jvmKt.identityHashCode(midVal);
            if (midIdentity < valueIdentity) {
                low = mid + 1;
                continue;
            }
            if (midIdentity > valueIdentity) {
                high = mid - 1;
                continue;
            }
            if (midVal == value) {
                return mid;
            }
            return this.findExactIndex(mid, value, valueIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object value, int valueHash) {
        Object v;
        int i;
        Object[] values2 = this.values;
        int size = this.size();
        for (i = midIndex - 1; -1 < i; --i) {
            v = values2[i];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) != valueHash) break;
        }
        for (i = midIndex + 1; i < size; ++i) {
            v = values2[i];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) == valueHash) continue;
            return -(i + 1);
        }
        return -(size + 1);
    }

    private final void checkIndexBounds(int index) {
        if (!(0 <= index ? index < this.size() : false)) {
            throw new IndexOutOfBoundsException("Index " + index + ", size " + this.size());
        }
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int index;
            final /* synthetic */ IdentityArraySet<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            public boolean hasNext() {
                return this.index < this.this$0.size();
            }

            @NotNull
            public T next() {
                int n = this.index;
                this.index = n + 1;
                Object object = this.this$0.getValues()[n];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
                return (T)object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)toString.1.INSTANCE, (int)25, null);
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

