/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/runtime/lint/RememberDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "runtime-lint"})
@SourceDebugExtension(value={"SMAP\nRememberDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RememberDetector.kt\nandroidx/compose/runtime/lint/RememberDetector\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,105:1\n169#2:106\n*S KotlinDebug\n*F\n+ 1 RememberDetector.kt\nandroidx/compose/runtime/lint/RememberDetector\n*L\n65#1:106\n*E\n"})
public final class RememberDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue RememberReturnType = Issue.Companion.create("RememberReturnType", "`remember` calls must not return `Unit`", "A call to `remember` that returns `Unit` is always an error. This typically happens when using `remember` to mutate variables on an object. `remember` is executed during the composition, which means that if the composition fails or is happening on a separate thread, the mutated variables may not reflect the true state of the composition. Instead, use `SideEffect` to make deferred changes once the composition succeeds, or mutate `MutableState` backed variables directly, as these will handle composition failure for you.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(RememberDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Runtime.INSTANCE.getRemember().getShortName());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block6: {
            block7: {
                block8: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        if (!PsiUtilsKt.isInPackageName(method, Names.Runtime.INSTANCE.getPackageName())) {
                            return;
                        }
                        callExpressionType = node.getExpressionType();
                        if (!PsiUtilsKt.isVoidOrUnit(callExpressionType)) {
                            return;
                        }
                        sourcePsi = node.getSourcePsi();
                        v0 = (PsiType)CollectionsKt.singleOrNull((List)node.getTypeArguments());
                        v1 = v0 != null ? PsiUtilsKt.isVoidOrUnit(v0) : false;
                        if (!v1) break block5;
                        v2 = true;
                        break block6;
                    }
                    if (!(sourcePsi instanceof KtCallExpression)) break block7;
                    v3 = method.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"method.parameters");
                    calculationParameterIndex = ArraysKt.getLastIndex((Object[])v3);
                    v4 = node.getArgumentForParameter(calculationParameterIndex);
                    v5 /* !! */  = argument = v4 != null ? v4.getSourcePsi() : null;
                    if (!(argument instanceof KtLambdaExpression)) break block8;
                    v6 /* !! */  = ((KtLambdaExpression)argument).getBodyExpression();
                    lastExp = v6 /* !! */  != null && (v6 /* !! */  = v6 /* !! */ .getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)v6 /* !! */ ) : null;
                    v7 = lastExp;
                    if (v7 == null) ** GOTO lbl-1000
                    $this$toUElementOfType$iv = (PsiElement)v7;
                    $i$f$toUElementOfType = false;
                    v7 = (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
                    if (v7 != null) {
                        v8 = v7.getExpressionType();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = null;
                    }
                    lastExpType = v8;
                    v2 = Intrinsics.areEqual((Object)callExpressionType, lastExpType);
                    break block6;
                }
                v2 = true;
                break block6;
            }
            v2 = isReallyUnit = true;
        }
        if (isReallyUnit) {
            JavaContext.report$default((JavaContext)context, (Issue)RememberDetector.RememberReturnType, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"`remember` calls must not return `Unit`", null, (int)16, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/lint/RememberDetector$Companion;", "", "()V", "RememberReturnType", "Lcom/android/tools/lint/detector/api/Issue;", "getRememberReturnType", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getRememberReturnType() {
            return RememberReturnType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

