/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/runtime/lint/CompositionLocalNamingDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UVariable;", "Companion", "runtime-lint"})
public final class CompositionLocalNamingDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue CompositionLocalNaming = Issue.Companion.create("CompositionLocalNaming", "CompositionLocal properties should be prefixed with `Local`", "CompositionLocal properties should be prefixed with `Local`. This helps make it clear at their use site that these values are local to the current composition. Typically the full name will be `Local` + the type of the CompositionLocal, for example val LocalFoo = compositionLocalOf { Foo() }.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(CompositionLocalNamingDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UVariable>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UVariable.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitVariable(UVariable node) {
                String name;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof UParameter) {
                    return;
                }
                if (node.getSourcePsi() instanceof KtParameter) {
                    return;
                }
                PsiElement psiElement = node.getSourcePsi();
                KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
                boolean bl = ktProperty != null ? ktProperty.isLocal() : false;
                if (bl) {
                    return;
                }
                PsiType type = node.getType();
                if (!PsiUtilsKt.inheritsFrom(type, Names.Runtime.INSTANCE.getCompositionLocal())) {
                    return;
                }
                String string = name = node.getName();
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.startsWith((String)string, (String)"Local", (boolean)true)) {
                    return;
                }
                UElement uElementNode = (UElement)node;
                JavaContext.report$default((JavaContext)this.$context, (Issue)CompositionLocalNamingDetector.Companion.getCompositionLocalNaming(), (UElement)uElementNode, (Location)this.$context.getNameLocation(uElementNode), (String)"CompositionLocal properties should be prefixed with `Local`", null, (int)16, null);
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/lint/CompositionLocalNamingDetector$Companion;", "", "()V", "CompositionLocalNaming", "Lcom/android/tools/lint/detector/api/Issue;", "getCompositionLocalNaming", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getCompositionLocalNaming() {
            return CompositionLocalNaming;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

