/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u0016H\u0002J\f\u0010\u001a\u001a\u00020\u0005*\u00020\u0016H\u0002J\f\u0010\u001b\u001a\u00020\u0005*\u00020\u0014H\u0002J\f\u0010\u001c\u001a\u00020\u0005*\u00020\u0016H\u0002J\f\u0010\u001d\u001a\u00020\u0005*\u00020\u0014H\u0002J\f\u0010\u001e\u001a\u00020\u0005*\u00020\u0016H\u0002J\f\u0010\u001f\u001a\u00020\u0016*\u00020\u0012H\u0002R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006!"}, d2={"Landroidx/compose/runtime/lint/OpaqueUnitKeyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "isVirtual", "", "Lorg/jetbrains/uast/UElement;", "(Lorg/jetbrains/uast/UElement;)Z", "getApplicableMethodNames", "", "", "reportOpaqueUnitArgKey", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "method", "Lcom/intellij/psi/PsiMethod;", "methodInvocation", "Lorg/jetbrains/uast/UCallExpression;", "parameter", "Lcom/intellij/psi/PsiParameter;", "argument", "Lorg/jetbrains/uast/UExpression;", "visitMethodCall", "node", "getParentExpression", "isInPhysicalBlock", "isNullableAny", "isOpaqueUnitExpression", "isPotentiallyVarArgs", "isUnitLiteral", "resolveRootExpression", "Companion", "runtime-lint"})
@SourceDebugExtension(value={"SMAP\nOpaqueUnitKeyDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpaqueUnitKeyDetector.kt\nandroidx/compose/runtime/lint/OpaqueUnitKeyDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n13309#2:262\n13310#2:265\n12474#2,2:266\n1855#3,2:263\n*S KotlinDebug\n*F\n+ 1 OpaqueUnitKeyDetector.kt\nandroidx/compose/runtime/lint/OpaqueUnitKeyDetector\n*L\n75#1:262\n75#1:265\n212#1:266,2\n88#1:263,2\n*E\n"})
public final class OpaqueUnitKeyDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FqJavaObjectName = "java.lang.Object";
    @NotNull
    private static final String FqUnitName = "kotlin.Unit";
    @NotNull
    private static final String FqKotlinNullableAnnotation = "org.jetbrains.annotations.Nullable";
    @NotNull
    private static final Issue OpaqueUnitKey = Issue.Companion.create("OpaqueUnitKey", "Passing an expression which always returns `Unit` as a key argument", "Certain Compose functions including `remember`, `LaunchedEffect`, and `DisposableEffect` declare (and sometimes require) one or more key parameters. When a key parameter changes, it is a signal that the previous invocation is now invalid. In certain cases, it may be required to pass `Unit` as a key to one of these functions, indicating that the invocation never becomes invalid. Using `Unit` as a key should be done infrequently, and should always be done explicitly by passing the `Unit` literal. This inspection checks for invocations where `Unit` is being passed as a key argument in any form other than the `Unit` literal. This is usually done by mistake, and can harm readability. If a Unit expression is being passed as a key, it is always equivalent to move the expression before the function invocation and pass the `Unit` literal instead.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(OpaqueUnitKeyDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{Names.Runtime.INSTANCE.getRemember().getShortName(), Names.Runtime.INSTANCE.getRememberSaveable().getShortName(), Names.Runtime.INSTANCE.getDisposableEffect().getShortName(), Names.Runtime.INSTANCE.getLaunchedEffect().getShortName(), Names.Runtime.INSTANCE.getProduceState().getShortName(), Names.Runtime.INSTANCE.getReusableContent().getShortName(), Names.Runtime.INSTANCE.getKey().getShortName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName(method, Names.Runtime.INSTANCE.getPackageName())) {
            return;
        }
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"method.parameterList.parameters");
        Object[] $this$forEach$iv = psiParameterArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiParameter parameter = (PsiParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            UExpression arg = node.getArgumentForParameter(KtPsiUtilKt.parameterIndex((PsiElement)((PsiElement)parameter)));
            if (this.isNullableAny(parameter)) {
                UExpression uExpression = arg;
                boolean bl2 = uExpression != null ? this.isOpaqueUnitExpression(uExpression) : false;
                if (!bl2) continue;
                this.reportOpaqueUnitArgKey(context, method, node, parameter, arg);
                continue;
            }
            if (!this.isPotentiallyVarArgs(parameter) || !(arg instanceof UExpressionList)) continue;
            Iterable $this$forEach$iv2 = ((UExpressionList)arg).getExpressions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UExpression varArg = (UExpression)element$iv2;
                boolean bl3 = false;
                if (!this.isOpaqueUnitExpression(varArg)) continue;
                this.reportOpaqueUnitArgKey(context, method, node, parameter, varArg);
            }
        }
    }

    private final void reportOpaqueUnitArgKey(JavaContext context, PsiMethod method, UCallExpression methodInvocation, PsiParameter parameter, UExpression argument) {
        LintFix lintFix;
        UExpression rootExpression = this.resolveRootExpression(methodInvocation);
        Location rootExpressionLocation = context.getLocation((UElement)rootExpression);
        String name = "Move expression outside of `" + method.getName() + "`'s arguments and pass `Unit` explicitly";
        UElement uElement = (UElement)argument;
        Location location = context.getLocation((UElement)argument);
        String string = "Implicitly passing `Unit` as argument to " + parameter.getName();
        LintFix.Builder builder = this.fix().name(name);
        LintFix[] lintFixArray = new LintFix[2];
        if (this.isInPhysicalBlock(rootExpression)) {
            lintFix = this.fix().replace().range(rootExpressionLocation).beginning().with(argument.asSourceString() + "\n").reformat(true).build();
        } else {
            LintFix[] lintFixArray2 = new LintFix[]{this.fix().replace().range(rootExpressionLocation).beginning().with("kotlin.run {\n" + argument.asSourceString() + "\n").reformat(true).shortenNames().build(), this.fix().replace().range(rootExpressionLocation).end().with("\n}").reformat(true).build()};
            lintFix = this.fix().name(name).composite(lintFixArray2);
        }
        lintFixArray[0] = lintFix;
        lintFixArray[1] = this.fix().replace().range(context.getLocation((UElement)argument)).with(FqUnitName).shortenNames().build();
        context.report(OpaqueUnitKey, uElement, location, string, builder.composite(lintFixArray));
    }

    private final UExpression resolveRootExpression(UCallExpression $this$resolveRootExpression) {
        UExpression root = (UExpression)$this$resolveRootExpression;
        UExpression parent = this.getParentExpression(root);
        while (parent != null && !(parent instanceof UBlockExpression)) {
            if (!this.isVirtual((UElement)parent)) {
                root = parent;
            }
            parent = this.getParentExpression(parent);
        }
        return root;
    }

    private final boolean isInPhysicalBlock(UExpression $this$isInPhysicalBlock) {
        for (UElement parent = (UElement)$this$isInPhysicalBlock; parent != null; parent = parent.getUastParent()) {
            if (!(parent instanceof UBlockExpression)) continue;
            return !this.isVirtual(parent);
        }
        return false;
    }

    private final boolean isVirtual(UElement $this$isVirtual) {
        return $this$isVirtual.getSourcePsi() == null;
    }

    private final UExpression getParentExpression(UExpression $this$getParentExpression) {
        UExpression uExpression;
        UElement parent = $this$getParentExpression.getUastParent();
        if (parent instanceof UVariable) {
            UElement uElement = parent.getUastParent();
            Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UDeclarationsExpression");
            uExpression = (UExpression)((UDeclarationsExpression)uElement);
        } else {
            uExpression = parent instanceof UExpression ? (UExpression)parent : null;
        }
        return uExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNullableAny(PsiParameter $this$isNullableAny) {
        UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)$this$isNullableAny));
        if (!(uElement instanceof UParameter)) return false;
        UParameter uParameter = (UParameter)uElement;
        if (uParameter == null) {
            return false;
        }
        UParameter element = uParameter;
        if (!Intrinsics.areEqual((Object)element.getType().getCanonicalText(), (Object)FqJavaObjectName)) return false;
        PsiAnnotation[] psiAnnotationArray = element.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"element.getAnnotations()");
        Object[] $this$any$iv = psiAnnotationArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            PsiAnnotation it = (PsiAnnotation)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)FqKotlinNullableAnnotation)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean isPotentiallyVarArgs(PsiParameter $this$isPotentiallyVarArgs) {
        return Intrinsics.areEqual((Object)$this$isPotentiallyVarArgs.getType().getCanonicalText(), (Object)"java.lang.Object[]");
    }

    private final boolean isOpaqueUnitExpression(UExpression $this$isOpaqueUnitExpression) {
        return PsiUtilsKt.isVoidOrUnit($this$isOpaqueUnitExpression.getExpressionType()) && !this.isUnitLiteral($this$isOpaqueUnitExpression);
    }

    private final boolean isUnitLiteral(UExpression $this$isUnitLiteral) {
        UExpression expr = UastUtils.skipParenthesizedExprDown((UExpression)$this$isUnitLiteral);
        if (!(expr instanceof USimpleNameReferenceExpression)) {
            return false;
        }
        UDeclaration uDeclaration = UastLintUtils.Companion.tryResolveUDeclaration((UElement)expr);
        UClass uClass = uDeclaration instanceof UClass ? (UClass)uDeclaration : null;
        return Intrinsics.areEqual((Object)(uClass != null ? uClass.getQualifiedName() : null), (Object)FqUnitName);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/compose/runtime/lint/OpaqueUnitKeyDetector$Companion;", "", "()V", "FqJavaObjectName", "", "FqKotlinNullableAnnotation", "FqUnitName", "OpaqueUnitKey", "Lcom/android/tools/lint/detector/api/Issue;", "getOpaqueUnitKey", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getOpaqueUnitKey() {
            return OpaqueUnitKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

