/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.autofill;

import android.util.Log;
import android.util.SparseArray;
import android.view.ViewStructure;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.autofill.AndroidAutofill;
import androidx.compose.ui.autofill.AndroidAutofillType_androidKt;
import androidx.compose.ui.autofill.AutofillApi23Helper;
import androidx.compose.ui.autofill.AutofillApi26Helper;
import androidx.compose.ui.autofill.AutofillNode;
import androidx.compose.ui.autofill.AutofillType;
import androidx.compose.ui.geometry.Rect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0001\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a8\u0006\t"}, d2={"performAutofill", "", "Landroidx/compose/ui/autofill/AndroidAutofill;", "values", "Landroid/util/SparseArray;", "Landroid/view/autofill/AutofillValue;", "populateViewStructure", "root", "Landroid/view/ViewStructure;", "ui_release"})
@SourceDebugExtension(value={"SMAP\nAndroidAutofill.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidAutofill.android.kt\nandroidx/compose/ui/autofill/AndroidAutofill_androidKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,230:1\n151#2,3:231\n33#2,4:234\n154#2,2:238\n38#2:240\n156#2:241\n37#3,2:242\n*S KotlinDebug\n*F\n+ 1 AndroidAutofill.android.kt\nandroidx/compose/ui/autofill/AndroidAutofill_androidKt\n*L\n96#1:231,3\n96#1:234,4\n96#1:238,2\n96#1:240\n96#1:241\n96#1:242,2\n*E\n"})
public final class AndroidAutofill_androidKt {
    /*
     * WARNING - void declaration
     */
    @ExperimentalComposeUiApi
    @RequiresApi(value=26)
    public static final void populateViewStructure(@NotNull AndroidAutofill $this$populateViewStructure, @NotNull ViewStructure root2) {
        Intrinsics.checkNotNullParameter((Object)$this$populateViewStructure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        int index = AutofillApi23Helper.INSTANCE.addChildCount(root2, $this$populateViewStructure.getAutofillTree().getChildren().size());
        for (Map.Entry<Integer, AutofillNode> entry : $this$populateViewStructure.getAutofillTree().getChildren().entrySet()) {
            int id = ((Number)entry.getKey()).intValue();
            AutofillNode autofillNode = entry.getValue();
            if (AutofillApi23Helper.INSTANCE.newChild(root2, index) != null) {
                void $this$toTypedArray$iv;
                Collection<String> collection;
                Collection $this$fastMap$iv;
                ViewStructure viewStructure;
                ViewStructure child = viewStructure;
                boolean bl = false;
                AutofillId autofillId = AutofillApi26Helper.INSTANCE.getAutofillId(root2);
                Intrinsics.checkNotNull((Object)autofillId);
                AutofillApi26Helper.INSTANCE.setAutofillId(child, autofillId, id);
                AutofillApi23Helper.INSTANCE.setId(child, id, $this$populateViewStructure.getView().getContext().getPackageName(), null, null);
                AutofillApi26Helper.INSTANCE.setAutofillType(child, 1);
                List<AutofillType> list = autofillNode.getAutofillTypes();
                ViewStructure viewStructure2 = child;
                AutofillApi26Helper autofillApi26Helper = AutofillApi26Helper.INSTANCE;
                boolean $i$f$fastMap = false;
                ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
                void $this$fastForEach$iv$iv = $this$fastMap$iv;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    void it;
                    Object item$iv$iv;
                    Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    AutofillType autofillType = (AutofillType)((Object)it$iv);
                    collection = target$iv;
                    boolean bl3 = false;
                    collection.add(AndroidAutofillType_androidKt.getAndroidType((AutofillType)it));
                }
                collection = target$iv;
                $this$fastMap$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                autofillApi26Helper.setAutofillHints(viewStructure2, thisCollection$iv.toArray(new String[0]));
                Rect boundingBox = autofillNode.getBoundingBox();
                if (boundingBox == null) {
                    Log.w((String)"Autofill Warning", (String)"Bounding box not set.\n                        Did you call perform autofillTree before the component was positioned? ");
                } else {
                    int left = MathKt.roundToInt((float)boundingBox.getLeft());
                    int top = MathKt.roundToInt((float)boundingBox.getTop());
                    int right = MathKt.roundToInt((float)boundingBox.getRight());
                    int bottom = MathKt.roundToInt((float)boundingBox.getBottom());
                    int width = right - left;
                    int height = bottom - top;
                    AutofillApi23Helper.INSTANCE.setDimens(child, left, top, 0, 0, width, height);
                }
            }
            ++index;
        }
    }

    @ExperimentalComposeUiApi
    @RequiresApi(value=26)
    public static final void performAutofill(@NotNull AndroidAutofill $this$performAutofill, @NotNull SparseArray<AutofillValue> values) {
        Intrinsics.checkNotNullParameter((Object)$this$performAutofill, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        int n = values.size();
        for (int index = 0; index < n; ++index) {
            int itemId = values.keyAt(index);
            AutofillValue value = (AutofillValue)values.get(itemId);
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            if (AutofillApi26Helper.INSTANCE.isText(value)) {
                $this$performAutofill.getAutofillTree().performAutofill(itemId, ((Object)AutofillApi26Helper.INSTANCE.textValue(value)).toString());
                continue;
            }
            if (AutofillApi26Helper.INSTANCE.isDate(value)) {
                String string = "b/138604541: Add onFill() callback for date";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (AutofillApi26Helper.INSTANCE.isList(value)) {
                String string = "b/138604541: Add onFill() callback for list";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (!AutofillApi26Helper.INSTANCE.isToggle(value)) continue;
            String string = "b/138604541:  Add onFill() callback for toggle";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }
}

