/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import android.graphics.Matrix;
import android.view.inputmethod.CursorAnchorInfo;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"build", "Landroid/view/inputmethod/CursorAnchorInfo;", "Landroid/view/inputmethod/CursorAnchorInfo$Builder;", "textFieldValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "matrix", "Landroid/graphics/Matrix;", "setInsertionMarker", "selectionStart", "", "ui_release"})
public final class CursorAnchorInfoBuilderKt {
    @NotNull
    public static final CursorAnchorInfo build(@NotNull CursorAnchorInfo.Builder $this$build, @NotNull TextFieldValue textFieldValue, @NotNull TextLayoutResult textLayoutResult, @NotNull Matrix matrix) {
        int compositionEnd;
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"textFieldValue");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        $this$build.reset();
        $this$build.setMatrix(matrix);
        int selectionStart = TextRange.getMin-impl((long)textFieldValue.getSelection-d9O1mEE());
        int selectionEnd = TextRange.getMax-impl((long)textFieldValue.getSelection-d9O1mEE());
        $this$build.setSelectionRange(selectionStart, selectionEnd);
        CursorAnchorInfoBuilderKt.setInsertionMarker($this$build, selectionStart, textLayoutResult);
        TextRange textRange = textFieldValue.getComposition-MzsxiRA();
        int compositionStart = textRange != null ? TextRange.getMin-impl((long)textRange.unbox-impl()) : -1;
        TextRange textRange2 = textFieldValue.getComposition-MzsxiRA();
        int n = compositionEnd = textRange2 != null ? TextRange.getMax-impl((long)textRange2.unbox-impl()) : -1;
        boolean bl = 0 <= compositionStart ? compositionStart < compositionEnd : false;
        if (bl) {
            $this$build.setComposingText(compositionStart, textFieldValue.getText().subSequence(compositionStart, compositionEnd));
        }
        CursorAnchorInfo cursorAnchorInfo = $this$build.build();
        Intrinsics.checkNotNullExpressionValue((Object)cursorAnchorInfo, (String)"build()");
        return cursorAnchorInfo;
    }

    private static final CursorAnchorInfo.Builder setInsertionMarker(CursorAnchorInfo.Builder $this$setInsertionMarker, int selectionStart, TextLayoutResult textLayoutResult) {
        if (selectionStart < 0) {
            return $this$setInsertionMarker;
        }
        Rect cursorRect = textLayoutResult.getCursorRect(selectionStart);
        boolean isRtl = textLayoutResult.getBidiRunDirection(selectionStart) == ResolvedTextDirection.Rtl;
        int flags = 0;
        if (isRtl) {
            flags |= 4;
        }
        $this$setInsertionMarker.setInsertionMarkerLocation(cursorRect.getLeft(), cursorRect.getTop(), cursorRect.getBottom(), cursorRect.getBottom(), flags);
        return $this$setInsertionMarker;
    }
}

