/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import android.view.Choreographer;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.CursorAnchorInfoController;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.InputEventCallback2;
import androidx.compose.ui.text.input.InputMethodManager;
import androidx.compose.ui.text.input.InputMethodManagerImpl;
import androidx.compose.ui.text.input.PlatformTextInput;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.RecordingInputConnection;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputServiceAndroid;
import androidx.compose.ui.text.input.TextInputServiceAndroid_androidKt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001PB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020#H\u0016J\u0010\u00105\u001a\u00020#2\u0006\u00106\u001a\u000207H\u0017J\b\u00108\u001a\u00020#H\u0002J\b\u00109\u001a\u00020#H\u0002J\u0010\u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020-H\u0002J\u0010\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020#H\u0016JI\u0010@\u001a\u00020#2\u0006\u0010A\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!\u0012\u0004\u0012\u00020#0 2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#0 H\u0016\u00f8\u0001\u0000J\b\u0010B\u001a\u00020#H\u0016J\u001a\u0010C\u001a\u00020#2\b\u0010D\u001a\u0004\u0018\u00010'2\u0006\u0010E\u001a\u00020'H\u0016J=\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020'2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u0002072\u0006\u0010M\u001a\u000207H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bN\u0010OR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!\u0012\u0004\u0012\u00020#0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#0 X\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006Q"}, d2={"Landroidx/compose/ui/text/input/TextInputServiceAndroid;", "Landroidx/compose/ui/text/input/PlatformTextInputService;", "view", "Landroid/view/View;", "context", "Landroidx/compose/ui/text/input/PlatformTextInput;", "(Landroid/view/View;Landroidx/compose/ui/text/input/PlatformTextInput;)V", "inputMethodManager", "Landroidx/compose/ui/text/input/InputMethodManager;", "platformTextInput", "inputCommandProcessorExecutor", "Ljava/util/concurrent/Executor;", "(Landroid/view/View;Landroidx/compose/ui/text/input/InputMethodManager;Landroidx/compose/ui/text/input/PlatformTextInput;Ljava/util/concurrent/Executor;)V", "baseInputConnection", "Landroid/view/inputmethod/BaseInputConnection;", "getBaseInputConnection", "()Landroid/view/inputmethod/BaseInputConnection;", "baseInputConnection$delegate", "Lkotlin/Lazy;", "cursorAnchorInfoController", "Landroidx/compose/ui/text/input/CursorAnchorInfoController;", "focusedRect", "Landroid/graphics/Rect;", "frameCallback", "Ljava/lang/Runnable;", "ics", "", "Ljava/lang/ref/WeakReference;", "Landroidx/compose/ui/text/input/RecordingInputConnection;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "<set-?>", "Landroidx/compose/ui/text/input/TextFieldValue;", "state", "getState$ui_release", "()Landroidx/compose/ui/text/input/TextFieldValue;", "textInputCommandQueue", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/text/input/TextInputServiceAndroid$TextInputCommand;", "getView", "()Landroid/view/View;", "createInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "hideSoftwareKeyboard", "notifyFocusedRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "processInputCommands", "restartInputImmediately", "sendInputCommand", "command", "setKeyboardVisibleImmediately", "visible", "", "showSoftwareKeyboard", "startInput", "value", "stopInput", "updateState", "oldValue", "newValue", "updateTextLayoutResult", "textFieldValue", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "textLayoutPositionInWindow", "Landroidx/compose/ui/geometry/Offset;", "innerTextFieldBounds", "decorationBoxBounds", "updateTextLayoutResult-38CYSgM", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/text/TextLayoutResult;JLandroidx/compose/ui/geometry/Rect;Landroidx/compose/ui/geometry/Rect;)V", "TextInputCommand", "ui_release"})
@SourceDebugExtension(value={"SMAP\nTextInputServiceAndroid.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextInputServiceAndroid.android.kt\nandroidx/compose/ui/text/input/TextInputServiceAndroid\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,546:1\n1182#2:547\n1161#2,2:548\n728#3,2:550\n460#3,11:553\n1#4:552\n*S KotlinDebug\n*F\n+ 1 TextInputServiceAndroid.android.kt\nandroidx/compose/ui/text/input/TextInputServiceAndroid\n*L\n105#1:547\n105#1:548,2\n227#1:550,2\n304#1:553,11\n*E\n"})
public final class TextInputServiceAndroid
implements PlatformTextInputService {
    @NotNull
    private final View view;
    @NotNull
    private final InputMethodManager inputMethodManager;
    @Nullable
    private final PlatformTextInput platformTextInput;
    @NotNull
    private final Executor inputCommandProcessorExecutor;
    @NotNull
    private Function1<? super List<? extends EditCommand>, Unit> onEditCommand;
    @NotNull
    private Function1<? super ImeAction, Unit> onImeActionPerformed;
    @NotNull
    private TextFieldValue state;
    @NotNull
    private ImeOptions imeOptions;
    @NotNull
    private List<WeakReference<RecordingInputConnection>> ics;
    @NotNull
    private final Lazy baseInputConnection$delegate;
    @Nullable
    private android.graphics.Rect focusedRect;
    @NotNull
    private final CursorAnchorInfoController cursorAnchorInfoController;
    @NotNull
    private final MutableVector<TextInputCommand> textInputCommandQueue;
    @Nullable
    private Runnable frameCallback;

    public TextInputServiceAndroid(@NotNull View view, @NotNull InputMethodManager inputMethodManager, @Nullable PlatformTextInput platformTextInput, @NotNull Executor inputCommandProcessorExecutor) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)inputMethodManager, (String)"inputMethodManager");
        Intrinsics.checkNotNullParameter((Object)inputCommandProcessorExecutor, (String)"inputCommandProcessorExecutor");
        this.view = view;
        this.inputMethodManager = inputMethodManager;
        this.platformTextInput = platformTextInput;
        this.inputCommandProcessorExecutor = inputCommandProcessorExecutor;
        this.onEditCommand = onEditCommand.1.INSTANCE;
        this.onImeActionPerformed = onImeActionPerformed.1.INSTANCE;
        this.state = new TextFieldValue("", TextRange.Companion.getZero-d9O1mEE(), null, 4, null);
        this.imeOptions = ImeOptions.Companion.getDefault();
        this.ics = new ArrayList();
        this.baseInputConnection$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<BaseInputConnection>(this){
            final /* synthetic */ TextInputServiceAndroid this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BaseInputConnection invoke() {
                return new BaseInputConnection(this.this$0.getView(), false);
            }
        }));
        this.cursorAnchorInfoController = new CursorAnchorInfoController(this.inputMethodManager);
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.textInputCommandQueue = new MutableVector((Object[])new TextInputCommand[capacity$iv$iv], 0);
    }

    public /* synthetic */ TextInputServiceAndroid(View view, InputMethodManager inputMethodManager, PlatformTextInput platformTextInput, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            platformTextInput = null;
        }
        if ((n & 8) != 0) {
            Choreographer choreographer = Choreographer.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)choreographer, (String)"getInstance()");
            executor = TextInputServiceAndroid_androidKt.asExecutor(choreographer);
        }
        this(view, inputMethodManager, platformTextInput, executor);
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    @NotNull
    public final TextFieldValue getState$ui_release() {
        return this.state;
    }

    private final BaseInputConnection getBaseInputConnection() {
        Lazy lazy = this.baseInputConnection$delegate;
        return (BaseInputConnection)lazy.getValue();
    }

    public TextInputServiceAndroid(@NotNull View view, @Nullable PlatformTextInput context) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this(view, new InputMethodManagerImpl(view), context, null, 8, null);
    }

    public /* synthetic */ TextInputServiceAndroid(View view, PlatformTextInput platformTextInput, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            platformTextInput = null;
        }
        this(view, platformTextInput);
    }

    @NotNull
    public final InputConnection createInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
        TextInputServiceAndroid_androidKt.update(outAttrs, this.imeOptions, this.state);
        TextInputServiceAndroid_androidKt.access$updateWithEmojiCompat(outAttrs);
        Object object = this.state;
        boolean bl = this.imeOptions.getAutoCorrect();
        InputEventCallback2 inputEventCallback2 = new InputEventCallback2(this){
            final /* synthetic */ TextInputServiceAndroid this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEditCommands(@NotNull List<? extends EditCommand> editCommands) {
                Intrinsics.checkNotNullParameter(editCommands, (String)"editCommands");
                TextInputServiceAndroid.access$getOnEditCommand$p(this.this$0).invoke(editCommands);
            }

            public void onImeAction-KlQnJC8(int imeAction) {
                TextInputServiceAndroid.access$getOnImeActionPerformed$p(this.this$0).invoke((Object)ImeAction.box-impl((int)imeAction));
            }

            public void onKeyEvent(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TextInputServiceAndroid.access$getBaseInputConnection(this.this$0).sendKeyEvent(event);
            }

            public void onRequestCursorAnchorInfo(boolean immediate, boolean monitor, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
                TextInputServiceAndroid.access$getCursorAnchorInfoController$p(this.this$0).requestUpdate(immediate, monitor, includeInsertionMarker, includeCharacterBounds, includeEditorBounds, includeLineBounds);
            }

            public void onConnectionClosed(@NotNull RecordingInputConnection ic) {
                Intrinsics.checkNotNullParameter((Object)ic, (String)"ic");
                int n = TextInputServiceAndroid.access$getIcs$p(this.this$0).size();
                for (int i = 0; i < n; ++i) {
                    if (!Intrinsics.areEqual(((WeakReference)TextInputServiceAndroid.access$getIcs$p(this.this$0).get(i)).get(), (Object)ic)) continue;
                    TextInputServiceAndroid.access$getIcs$p(this.this$0).remove(i);
                    return;
                }
            }
        };
        Object it = object = new RecordingInputConnection((TextFieldValue)object, inputEventCallback2, bl);
        boolean bl2 = false;
        this.ics.add(new WeakReference<TextFieldValue>((TextFieldValue)it));
        return (InputConnection)object;
    }

    public void startInput(@NotNull TextFieldValue value, @NotNull ImeOptions imeOptions, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand2, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed2) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand2, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed2, (String)"onImeActionPerformed");
        PlatformTextInput platformTextInput = this.platformTextInput;
        if (platformTextInput != null) {
            platformTextInput.requestInputFocus();
        }
        this.state = value;
        this.imeOptions = imeOptions;
        this.onEditCommand = onEditCommand2;
        this.onImeActionPerformed = onImeActionPerformed2;
        this.sendInputCommand(TextInputCommand.StartInput);
    }

    public void stopInput() {
        PlatformTextInput platformTextInput = this.platformTextInput;
        if (platformTextInput != null) {
            platformTextInput.releaseInputFocus();
        }
        this.onEditCommand = stopInput.1.INSTANCE;
        this.onImeActionPerformed = stopInput.2.INSTANCE;
        this.focusedRect = null;
        this.sendInputCommand(TextInputCommand.StopInput);
    }

    public void showSoftwareKeyboard() {
        this.sendInputCommand(TextInputCommand.ShowKeyboard);
    }

    public void hideSoftwareKeyboard() {
        this.sendInputCommand(TextInputCommand.HideKeyboard);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendInputCommand(TextInputCommand command) {
        MutableVector<TextInputCommand> this_$iv = this.textInputCommandQueue;
        boolean $i$f$plusAssign = false;
        this_$iv.add((Object)command);
        if (this.frameCallback == null) {
            void p0;
            Runnable runnable = () -> TextInputServiceAndroid.sendInputCommand$lambda$1(this);
            Executor executor = this.inputCommandProcessorExecutor;
            Runnable runnable2 = runnable;
            TextInputServiceAndroid textInputServiceAndroid = this;
            boolean bl = false;
            executor.execute((Runnable)p0);
            textInputServiceAndroid.frameCallback = runnable;
        }
    }

    private final void processInputCommands() {
        if (!this.view.isFocused()) {
            this.textInputCommandQueue.clear();
            return;
        }
        Ref.ObjectRef startInput = new Ref.ObjectRef();
        Ref.ObjectRef showKeyboard = new Ref.ObjectRef();
        MutableVector<TextInputCommand> this_$iv = this.textInputCommandQueue;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                TextInputCommand command = (TextInputCommand)((Object)content$iv[i$iv]);
                boolean bl = false;
                TextInputServiceAndroid.processInputCommands$applyToState(command, (Ref.ObjectRef<Boolean>)startInput, (Ref.ObjectRef<Boolean>)showKeyboard);
            } while (++i$iv < size$iv);
        }
        if (Intrinsics.areEqual((Object)startInput.element, (Object)true)) {
            this.restartInputImmediately();
        }
        Boolean bl = (Boolean)showKeyboard.element;
        if (bl != null) {
            Boolean bl2 = bl;
            boolean p0 = bl2;
            boolean bl3 = false;
            this.setKeyboardVisibleImmediately(p0);
        }
        if (Intrinsics.areEqual((Object)startInput.element, (Object)false)) {
            this.restartInputImmediately();
        }
    }

    public void updateState(@Nullable TextFieldValue oldValue, @NotNull TextFieldValue newValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        boolean needUpdateSelection = !TextRange.equals-impl0((long)this.state.getSelection-d9O1mEE(), (long)newValue.getSelection-d9O1mEE()) || !Intrinsics.areEqual((Object)this.state.getComposition-MzsxiRA(), (Object)newValue.getComposition-MzsxiRA());
        this.state = newValue;
        int n = this.ics.size();
        for (int i = 0; i < n; ++i) {
            RecordingInputConnection recordingInputConnection = (RecordingInputConnection)this.ics.get(i).get();
            if (recordingInputConnection == null) continue;
            recordingInputConnection.setMTextFieldValue$ui_release(newValue);
        }
        this.cursorAnchorInfoController.invalidate();
        if (Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
            if (needUpdateSelection) {
                TextRange textRange = this.state.getComposition-MzsxiRA();
                TextRange textRange2 = this.state.getComposition-MzsxiRA();
                this.inputMethodManager.updateSelection(TextRange.getMin-impl((long)newValue.getSelection-d9O1mEE()), TextRange.getMax-impl((long)newValue.getSelection-d9O1mEE()), textRange != null ? TextRange.getMin-impl((long)textRange.unbox-impl()) : -1, textRange2 != null ? TextRange.getMax-impl((long)textRange2.unbox-impl()) : -1);
            }
            return;
        }
        TextFieldValue textFieldValue = oldValue;
        if (textFieldValue != null) {
            TextFieldValue it = textFieldValue;
            boolean bl2 = false;
            bl = !Intrinsics.areEqual((Object)it.getText(), (Object)newValue.getText()) || TextRange.equals-impl0((long)it.getSelection-d9O1mEE(), (long)newValue.getSelection-d9O1mEE()) && !Intrinsics.areEqual((Object)it.getComposition-MzsxiRA(), (Object)newValue.getComposition-MzsxiRA());
        } else {
            bl = false;
        }
        boolean restartInput = bl;
        if (restartInput) {
            this.restartInputImmediately();
        } else {
            int n2 = this.ics.size();
            for (int i = 0; i < n2; ++i) {
                RecordingInputConnection recordingInputConnection = (RecordingInputConnection)this.ics.get(i).get();
                if (recordingInputConnection == null) continue;
                recordingInputConnection.updateInputState(this.state, this.inputMethodManager);
            }
        }
    }

    @Deprecated(message="This method should not be called, used BringIntoViewRequester instead.")
    public void notifyFocusedRect(@NotNull Rect rect) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            this.focusedRect = new android.graphics.Rect(MathKt.roundToInt((float)rect.getLeft()), MathKt.roundToInt((float)rect.getTop()), MathKt.roundToInt((float)rect.getRight()), MathKt.roundToInt((float)rect.getBottom()));
            if (!this.ics.isEmpty()) break block1;
            android.graphics.Rect rect2 = this.focusedRect;
            if (rect2 != null) {
                android.graphics.Rect it = rect2;
                boolean bl = false;
                this.view.requestRectangleOnScreen(new android.graphics.Rect(it));
            }
        }
    }

    public void updateTextLayoutResult-38CYSgM(@NotNull TextFieldValue textFieldValue, @NotNull TextLayoutResult textLayoutResult, long textLayoutPositionInWindow, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds) {
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"textFieldValue");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        Intrinsics.checkNotNullParameter((Object)innerTextFieldBounds, (String)"innerTextFieldBounds");
        Intrinsics.checkNotNullParameter((Object)decorationBoxBounds, (String)"decorationBoxBounds");
        this.cursorAnchorInfoController.updateTextLayoutResult-38CYSgM(textFieldValue, textLayoutResult, textLayoutPositionInWindow, innerTextFieldBounds, decorationBoxBounds);
    }

    private final void restartInputImmediately() {
        this.inputMethodManager.restartInput();
    }

    private final void setKeyboardVisibleImmediately(boolean visible) {
        if (visible) {
            this.inputMethodManager.showSoftInput();
        } else {
            this.inputMethodManager.hideSoftInput();
        }
    }

    private static final void sendInputCommand$lambda$1(TextInputServiceAndroid this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.frameCallback = null;
        this$0.processInputCommands();
    }

    private static final void processInputCommands$applyToState(TextInputCommand $this$processInputCommands_u24applyToState, Ref.ObjectRef<Boolean> startInput, Ref.ObjectRef<Boolean> showKeyboard) {
        switch (WhenMappings.$EnumSwitchMapping$0[$this$processInputCommands_u24applyToState.ordinal()]) {
            case 1: {
                startInput.element = true;
                showKeyboard.element = true;
                break;
            }
            case 2: {
                startInput.element = false;
                showKeyboard.element = false;
                break;
            }
            case 3: 
            case 4: {
                if (Intrinsics.areEqual((Object)startInput.element, (Object)false)) break;
                showKeyboard.element = $this$processInputCommands_u24applyToState == TextInputCommand.ShowKeyboard;
            }
        }
    }

    public static final /* synthetic */ Function1 access$getOnEditCommand$p(TextInputServiceAndroid $this) {
        return $this.onEditCommand;
    }

    public static final /* synthetic */ Function1 access$getOnImeActionPerformed$p(TextInputServiceAndroid $this) {
        return $this.onImeActionPerformed;
    }

    public static final /* synthetic */ BaseInputConnection access$getBaseInputConnection(TextInputServiceAndroid $this) {
        return $this.getBaseInputConnection();
    }

    public static final /* synthetic */ CursorAnchorInfoController access$getCursorAnchorInfoController$p(TextInputServiceAndroid $this) {
        return $this.cursorAnchorInfoController;
    }

    public static final /* synthetic */ List access$getIcs$p(TextInputServiceAndroid $this) {
        return $this.ics;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/text/input/TextInputServiceAndroid$TextInputCommand;", "", "(Ljava/lang/String;I)V", "StartInput", "StopInput", "ShowKeyboard", "HideKeyboard", "ui_release"})
    private static final class TextInputCommand
    extends Enum<TextInputCommand> {
        public static final /* enum */ TextInputCommand StartInput = new TextInputCommand();
        public static final /* enum */ TextInputCommand StopInput = new TextInputCommand();
        public static final /* enum */ TextInputCommand ShowKeyboard = new TextInputCommand();
        public static final /* enum */ TextInputCommand HideKeyboard = new TextInputCommand();
        private static final /* synthetic */ TextInputCommand[] $VALUES;

        public static TextInputCommand[] values() {
            return (TextInputCommand[])$VALUES.clone();
        }

        public static TextInputCommand valueOf(String value) {
            return Enum.valueOf(TextInputCommand.class, value);
        }

        static {
            $VALUES = textInputCommandArray = new TextInputCommand[]{TextInputCommand.StartInput, TextInputCommand.StopInput, TextInputCommand.ShowKeyboard, TextInputCommand.HideKeyboard};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextInputCommand.values().length];
            try {
                nArray[TextInputCommand.StartInput.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextInputCommand.StopInput.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextInputCommand.ShowKeyboard.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextInputCommand.HideKeyboard.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

