/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.NamesKt;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J<\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00060\u000fH\u0082\bJ#\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\rH\u0082\u0010J \u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a*\u0004\u0018\u00010\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u001a*\u00020\u001dH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/lint/SuspiciousCompositionLocalModifierReadDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "NodeLifecycleCallbacks", "", "", "getApplicableMethodNames", "report", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "usage", "Lorg/jetbrains/uast/UCallExpression;", "message", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "compositionLocalName", "reportIfAnyParentIsNodeLifecycleCallback", "node", "Lorg/jetbrains/uast/UElement;", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "isClConsumerNode", "", "Lcom/intellij/psi/PsiClass;", "isLazyDelegate", "Lorg/jetbrains/uast/kotlin/KotlinUFunctionCallExpression;", "Companion", "ui-lint"})
@SourceDebugExtension(value={"SMAP\nSuspiciousCompositionLocalModifierReadDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspiciousCompositionLocalModifierReadDetector.kt\nandroidx/compose/ui/lint/SuspiciousCompositionLocalModifierReadDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,139:1\n95#1,7:140\n103#1:148\n95#1,9:149\n95#1,9:158\n1#2:147\n12744#3,2:167\n*S KotlinDebug\n*F\n+ 1 SuspiciousCompositionLocalModifierReadDetector.kt\nandroidx/compose/ui/lint/SuspiciousCompositionLocalModifierReadDetector\n*L\n62#1:140,7\n62#1:148\n72#1:149,9\n79#1:158,9\n107#1:167,2\n*E\n"})
public final class SuspiciousCompositionLocalModifierReadDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> NodeLifecycleCallbacks;
    @NotNull
    private static final String ClConsumerModifierNode = "androidx.compose.ui.node.CompositionLocalConsumerModifierNode";
    @NotNull
    private static final Issue SuspiciousCompositionLocalModifierRead = Issue.Companion.create("SuspiciousCompositionLocalModifierRead", "CompositionLocals should not be read in Modifier.onAttach() or Modifier.onDetach()", "Jetpack Compose is unable to send updated values of a CompositionLocal when it's read in a Modifier.Node's initializer and onAttach() or onDetach() callbacks. Modifier.Node's callbacks are not aware of snapshot reads, and their lifecycle callbacks are not invoked on every recomposition. If you read a CompositionLocal in onAttach() or onDetach(), you will only get the CompositionLocal's value once at the moment of the read, which may lead to unexpected behaviors. We recommend instead reading CompositionLocals at time-of-use in callbacks that apply your Modifier's behavior, like measure() for LayoutModifierNode, draw() for DrawModifierNode, and so on. To observe the value of the CompositionLocal manually, extend from the ObserverNode interface and place the read inside an observeReads {} block within the onObservedReadsChanged() callback.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(SuspiciousCompositionLocalModifierReadDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    public SuspiciousCompositionLocalModifierReadDetector() {
        Object[] objectArray = new String[]{"onAttach", "onDetach"};
        this.NodeLifecycleCallbacks = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Ui.Node.INSTANCE.getCurrentValueOf().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        if (!PsiUtilsKt.isInPackageName(method, Names.Ui.Node.INSTANCE.getPackageName())) {
            return;
        }
        this.reportIfAnyParentIsNodeLifecycleCallback(context, (UElement)node, node);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportIfAnyParentIsNodeLifecycleCallback(JavaContext context, UElement node, UCallExpression usage) {
        while (node != null) {
            Object localBeingRead;
            UCallExpression uCallExpression;
            Object localBeingRead$iv;
            SuspiciousCompositionLocalModifierReadDetector this_$iv;
            if (node instanceof UMethod) {
                if (this_.isClConsumerNode(((UMethod)node).getContainingClass())) {
                    if (this_.NodeLifecycleCallbacks.contains(((UMethod)node).getName())) {
                        String string;
                        this_$iv = this_;
                        boolean $i$f$report = false;
                        Object object = usage.getArgumentForParameter(1);
                        if (object == null || (object = object.getSourcePsi()) == null || (object = object.getText()) == null) {
                            object = "a composition local";
                        }
                        localBeingRead$iv = object;
                        uCallExpression = localBeingRead$iv;
                        Location location = context.getLocation((UElement)usage);
                        Issue issue = Companion.getSuspiciousCompositionLocalModifierRead();
                        Context context2 = (Context)context;
                        boolean bl = false;
                        String string2 = StringsKt.removePrefix((String)((UMethod)node).getName(), (CharSequence)"on");
                        if (((CharSequence)string2).length() > 0) {
                            void it;
                            char c = string2.charAt(0);
                            StringBuilder stringBuilder = new StringBuilder();
                            boolean bl2 = false;
                            String string3 = String.valueOf((char)it);
                            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
                            String string4 = string3.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                            String string5 = string2;
                            int n = 1;
                            String string6 = string5.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                            string = stringBuilder2.append(string6).toString();
                        } else {
                            string = string2;
                        }
                        String action = string;
                        String string7 = "Reading " + (String)localBeingRead + " in " + ((UMethod)node).getName() + " will only access the CompositionLocal's value when the modifier is " + action + "ed. To be notified of the latest value of the CompositionLocal, read the value in one of the modifier's other callbacks.";
                        Context.report$default((Context)context2, (Issue)issue, (Location)location, (String)string7, null, (int)8, null);
                    } else if (((UMethod)node).isConstructor()) {
                        this_$iv = this_;
                        boolean $i$f$report = false;
                        Object object = usage.getArgumentForParameter(1);
                        if (object == null || (object = object.getSourcePsi()) == null || (object = object.getText()) == null) {
                            object = "a composition local";
                        }
                        localBeingRead = localBeingRead$iv = object;
                        Location location = context.getLocation((UElement)usage);
                        Issue issue = Companion.getSuspiciousCompositionLocalModifierRead();
                        Context context3 = (Context)context;
                        boolean bl = false;
                        String string = "CompositionLocals cannot be read in modifiers before the node is attached.";
                        Context.report$default((Context)context3, (Issue)issue, (Location)location, (String)string, null, (int)8, null);
                    }
                }
                return;
            }
            if (node instanceof KotlinUFunctionCallExpression && this_.isLazyDelegate((KotlinUFunctionCallExpression)node)) {
                this_$iv = this_;
                boolean $i$f$report = false;
                Object object = usage.getArgumentForParameter(1);
                if (object == null || (object = object.getSourcePsi()) == null || (object = object.getText()) == null) {
                    object = "a composition local";
                }
                Object it = localBeingRead$iv = object;
                Location location = context.getLocation((UElement)usage);
                Issue issue = Companion.getSuspiciousCompositionLocalModifierRead();
                Context context4 = (Context)context;
                boolean bl = false;
                String string = "Reading " + (String)localBeingRead + " lazily will only access the CompositionLocal's value once. To be notified of the latest value of the CompositionLocal, read the value in one of the modifier's callbacks.";
                Context.report$default((Context)context4, (Issue)issue, (Location)location, (String)string, null, (int)8, null);
                return;
            }
            SuspiciousCompositionLocalModifierReadDetector suspiciousCompositionLocalModifierReadDetector = this_;
            JavaContext javaContext = context;
            UElement uElement = node.getUastParent();
            uCallExpression = usage;
            SuspiciousCompositionLocalModifierReadDetector this_ = suspiciousCompositionLocalModifierReadDetector;
            context = javaContext;
            node = uElement;
            usage = uCallExpression;
        }
        return;
    }

    private final void report(JavaContext context, UCallExpression usage, Function1<? super String, String> message) {
        boolean $i$f$report = false;
        Object object = usage.getArgumentForParameter(1);
        if (object == null || (object = object.getSourcePsi()) == null || (object = object.getText()) == null) {
            object = "a composition local";
        }
        Object localBeingRead = object;
        Context.report$default((Context)((Context)context), (Issue)Companion.getSuspiciousCompositionLocalModifierRead(), (Location)context.getLocation((UElement)usage), (String)((String)message.invoke(localBeingRead)), null, (int)8, null);
    }

    private final boolean isClConsumerNode(PsiClass $this$isClConsumerNode) {
        boolean bl;
        PsiClassType[] psiClassTypeArray;
        if ($this$isClConsumerNode != null && (psiClassTypeArray = $this$isClConsumerNode.getImplementsListTypes()) != null) {
            boolean bl2;
            block3: {
                PsiClassType[] $this$any$iv = psiClassTypeArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiClassType element$iv;
                    PsiClassType it = element$iv = $this$any$iv[i];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getCanonicalText(), (Object)ClConsumerModifierNode)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isLazyDelegate(KotlinUFunctionCallExpression $this$isLazyDelegate) {
        boolean bl;
        PsiMethod psiMethod = $this$isLazyDelegate.resolve();
        if (psiMethod != null) {
            PsiMethod $this$isLazyDelegate_u24lambda_u245 = psiMethod;
            boolean bl2 = false;
            bl = PsiUtilsKt.isInPackageName($this$isLazyDelegate_u24lambda_u245, NamesKt.Package("kotlin")) && Intrinsics.areEqual((Object)$this$isLazyDelegate_u24lambda_u245.getName(), (Object)"lazy");
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/lint/SuspiciousCompositionLocalModifierReadDetector$Companion;", "", "()V", "ClConsumerModifierNode", "", "SuspiciousCompositionLocalModifierRead", "Lcom/android/tools/lint/detector/api/Issue;", "getSuspiciousCompositionLocalModifierRead", "()Lcom/android/tools/lint/detector/api/Issue;", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getSuspiciousCompositionLocalModifierRead() {
            return SuspiciousCompositionLocalModifierRead;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

