/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.res;

import android.content.res.Configuration;
import android.content.res.Resources;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.vector.GroupComponent;
import androidx.compose.ui.graphics.vector.ImageVector;
import androidx.compose.ui.unit.Density;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0019\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0086\u0002R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/res/ImageVectorCache;", "", "()V", "map", "Ljava/util/HashMap;", "Landroidx/compose/ui/res/ImageVectorCache$Key;", "Ljava/lang/ref/WeakReference;", "Landroidx/compose/ui/res/ImageVectorCache$ImageVectorEntry;", "Lkotlin/collections/HashMap;", "clear", "", "get", "key", "prune", "configChanges", "", "set", "imageVectorEntry", "ImageVectorEntry", "Key", "ui_release"})
public final class ImageVectorCache {
    @NotNull
    private final HashMap<Key, WeakReference<ImageVectorEntry>> map = new HashMap();

    @Nullable
    public final ImageVectorEntry get(@NotNull Key key) {
        WeakReference<ImageVectorEntry> weakReference = this.map.get(key);
        return weakReference != null ? (ImageVectorEntry)weakReference.get() : null;
    }

    public final void prune(int configChanges) {
        Iterator<Map.Entry<Key, WeakReference<ImageVectorEntry>>> it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Key, WeakReference<ImageVectorEntry>> entry = it.next();
            ImageVectorEntry imageVectorEntry = (ImageVectorEntry)entry.getValue().get();
            if (imageVectorEntry != null && !Configuration.needNewResources((int)configChanges, (int)imageVectorEntry.getConfigFlags())) continue;
            it.remove();
        }
    }

    public final void set(@NotNull Key key, @NotNull ImageVectorEntry imageVectorEntry) {
        ((Map)this.map).put(key, new WeakReference<ImageVectorEntry>(imageVectorEntry));
    }

    public final void clear() {
        this.map.clear();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/res/ImageVectorCache$ImageVectorEntry;", "", "imageVector", "Landroidx/compose/ui/graphics/vector/ImageVector;", "configFlags", "", "rootGroup", "Landroidx/compose/ui/graphics/vector/GroupComponent;", "(Landroidx/compose/ui/graphics/vector/ImageVector;ILandroidx/compose/ui/graphics/vector/GroupComponent;)V", "getConfigFlags", "()I", "getImageVector", "()Landroidx/compose/ui/graphics/vector/ImageVector;", "getRootGroup", "()Landroidx/compose/ui/graphics/vector/GroupComponent;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "ui_release"})
    @StabilityInferred(parameters=0)
    public static final class ImageVectorEntry {
        @NotNull
        private final ImageVector imageVector;
        private final int configFlags;
        @Nullable
        private final GroupComponent rootGroup;
        public static final int $stable = 8;

        public ImageVectorEntry(@NotNull ImageVector imageVector, int configFlags, @Nullable GroupComponent rootGroup) {
            this.imageVector = imageVector;
            this.configFlags = configFlags;
            this.rootGroup = rootGroup;
        }

        @NotNull
        public final ImageVector getImageVector() {
            return this.imageVector;
        }

        public final int getConfigFlags() {
            return this.configFlags;
        }

        @Nullable
        public final GroupComponent getRootGroup() {
            return this.rootGroup;
        }

        @NotNull
        public final ImageVector component1() {
            return this.imageVector;
        }

        public final int component2() {
            return this.configFlags;
        }

        @Nullable
        public final GroupComponent component3() {
            return this.rootGroup;
        }

        @NotNull
        public final ImageVectorEntry copy(@NotNull ImageVector imageVector, int configFlags, @Nullable GroupComponent rootGroup) {
            return new ImageVectorEntry(imageVector, configFlags, rootGroup);
        }

        public static /* synthetic */ ImageVectorEntry copy$default(ImageVectorEntry imageVectorEntry, ImageVector imageVector, int n, GroupComponent groupComponent, int n2, Object object) {
            if ((n2 & 1) != 0) {
                imageVector = imageVectorEntry.imageVector;
            }
            if ((n2 & 2) != 0) {
                n = imageVectorEntry.configFlags;
            }
            if ((n2 & 4) != 0) {
                groupComponent = imageVectorEntry.rootGroup;
            }
            return imageVectorEntry.copy(imageVector, n, groupComponent);
        }

        @NotNull
        public String toString() {
            return "ImageVectorEntry(imageVector=" + this.imageVector + ", configFlags=" + this.configFlags + ", rootGroup=" + this.rootGroup + ')';
        }

        public int hashCode() {
            int result2 = this.imageVector.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.configFlags);
            result2 = result2 * 31 + (this.rootGroup == null ? 0 : this.rootGroup.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImageVectorEntry)) {
                return false;
            }
            ImageVectorEntry imageVectorEntry = (ImageVectorEntry)other;
            if (!Intrinsics.areEqual((Object)this.imageVector, (Object)imageVectorEntry.imageVector)) {
                return false;
            }
            if (this.configFlags != imageVectorEntry.configFlags) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rootGroup, (Object)imageVectorEntry.rootGroup);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0010\u001a\u00060\u0003R\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J+\u0010\u0013\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003R\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/res/ImageVectorCache$Key;", "", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "id", "", "density", "Landroidx/compose/ui/unit/Density;", "(Landroid/content/res/Resources$Theme;ILandroidx/compose/ui/unit/Density;)V", "getDensity", "()Landroidx/compose/ui/unit/Density;", "getId", "()I", "getTheme", "()Landroid/content/res/Resources$Theme;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "ui_release"})
    @StabilityInferred(parameters=0)
    public static final class Key {
        @NotNull
        private final Resources.Theme theme;
        private final int id;
        @NotNull
        private final Density density;
        public static final int $stable = 8;

        public Key(@NotNull Resources.Theme theme, int id2, @NotNull Density density) {
            this.theme = theme;
            this.id = id2;
            this.density = density;
        }

        @NotNull
        public final Resources.Theme getTheme() {
            return this.theme;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final Density getDensity() {
            return this.density;
        }

        @NotNull
        public final Resources.Theme component1() {
            return this.theme;
        }

        public final int component2() {
            return this.id;
        }

        @NotNull
        public final Density component3() {
            return this.density;
        }

        @NotNull
        public final Key copy(@NotNull Resources.Theme theme, int id2, @NotNull Density density) {
            return new Key(theme, id2, density);
        }

        public static /* synthetic */ Key copy$default(Key key, Resources.Theme theme, int n, Density density, int n2, Object object) {
            if ((n2 & 1) != 0) {
                theme = key.theme;
            }
            if ((n2 & 2) != 0) {
                n = key.id;
            }
            if ((n2 & 4) != 0) {
                density = key.density;
            }
            return key.copy(theme, n, density);
        }

        @NotNull
        public String toString() {
            return "Key(theme=" + this.theme + ", id=" + this.id + ", density=" + this.density + ')';
        }

        public int hashCode() {
            int result2 = this.theme.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.id);
            result2 = result2 * 31 + this.density.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.theme, (Object)key.theme)) {
                return false;
            }
            if (this.id != key.id) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.density, (Object)key.density);
        }
    }
}

