/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.collection.LongSparseArray;
import androidx.collection.MutableObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.Node;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J.\u0010\u0017\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0006\u0010\u0018\u001a\u00020\u0013J\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/input/pointer/NodeParent;", "", "()V", "children", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/input/pointer/Node;", "getChildren", "()Landroidx/compose/runtime/collection/MutableVector;", "buildCache", "", "changes", "Landroidx/collection/LongSparseArray;", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "parentCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "internalPointerEvent", "Landroidx/compose/ui/input/pointer/InternalPointerEvent;", "isInBounds", "cleanUpHits", "", "clear", "dispatchCancel", "dispatchFinalEventPass", "dispatchMainEventPass", "removeDetachedPointerInputModifierNodes", "removeInvalidPointerIdsAndChanges", "pointerIdValue", "", "hitNodes", "Landroidx/collection/MutableObjectList;", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHitPathTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,647:1\n1208#2:648\n1187#2,2:649\n460#3,11:651\n460#3,11:662\n460#3,11:673\n460#3,11:684\n460#3,11:695\n523#3:706\n48#3:707\n523#3:708\n*S KotlinDebug\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n*L\n189#1:648\n189#1:649,2\n198#1:651,11\n228#1:662,11\n247#1:673,11\n258#1:684,11\n272#1:695,11\n283#1:706\n296#1:707\n297#1:708\n*E\n"})
public class NodeParent {
    @NotNull
    private final MutableVector<Node> children;
    public static final int $stable = MutableVector.$stable;

    public NodeParent() {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.children = new MutableVector((Object[])new Node[capacity$iv$iv], 0);
    }

    @NotNull
    public final MutableVector<Node> getChildren() {
        return this.children;
    }

    public boolean buildCache(@NotNull LongSparseArray<PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        boolean changed = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                changed = it.buildCache(changes, parentCoordinates, internalPointerEvent, isInBounds) || changed;
            } while (++i$iv < size$iv);
        }
        return changed;
    }

    public boolean dispatchMainEventPass(@NotNull LongSparseArray<PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                dispatched = it.dispatchMainEventPass(changes, parentCoordinates, internalPointerEvent, isInBounds) || dispatched;
            } while (++i$iv < size$iv);
        }
        return dispatched;
    }

    public boolean dispatchFinalEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                dispatched = it.dispatchFinalEventPass(internalPointerEvent) || dispatched;
            } while (++i$iv < size$iv);
        }
        this.cleanUpHits(internalPointerEvent);
        return dispatched;
    }

    public void dispatchCancel() {
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.dispatchCancel();
            } while (++i$iv < size$iv);
        }
    }

    public final void clear() {
        this.children.clear();
    }

    public void removeInvalidPointerIdsAndChanges(long pointerIdValue, @NotNull MutableObjectList<Node> hitNodes) {
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.removeInvalidPointerIdsAndChanges(pointerIdValue, hitNodes);
            } while (++i$iv < size$iv);
        }
    }

    public final void removeDetachedPointerInputModifierNodes() {
        int index = 0;
        while (index < this.children.getSize()) {
            MutableVector<Node> this_$iv = this.children;
            boolean $i$f$get = false;
            Node child = (Node)this_$iv.getContent()[index];
            if (!child.getModifierNode().isAttached()) {
                child.dispatchCancel();
                this.children.removeAt(index);
                continue;
            }
            ++index;
            child.removeDetachedPointerInputModifierNodes();
        }
    }

    public void cleanUpHits(@NotNull InternalPointerEvent internalPointerEvent) {
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv.getSize() - 1; -1 < i; --i) {
            MutableVector<Node> this_$iv2 = this.children;
            boolean $i$f$get = false;
            Node child = (Node)this_$iv2.getContent()[i];
            if (!child.getPointerIds().isEmpty()) continue;
            this.children.removeAt(i);
        }
    }
}

